package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class AlertingSpecFluentImpl<A extends AlertingSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AlertingSpecFluent<A> {

    private List<AlertmanagerEndpointsBuilder> alertmanagers =  new ArrayList<AlertmanagerEndpointsBuilder>();

    public AlertingSpecFluentImpl() { 
    }


    public AlertingSpecFluentImpl(AlertingSpec instance) { 
        this.withAlertmanagers(instance.getAlertmanagers()); 
    }


    public A addToAlertmanagers(int index,AlertmanagerEndpoints item) {
        if (this.alertmanagers == null) {this.alertmanagers = new ArrayList<AlertmanagerEndpointsBuilder>();}
        AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);_visitables.get("alertmanagers").add(index >= 0 ? index : _visitables.get("alertmanagers").size(), builder);this.alertmanagers.add(index >= 0 ? index : alertmanagers.size(), builder); return (A)this;
    }

    public A setToAlertmanagers(int index,AlertmanagerEndpoints item) {
        if (this.alertmanagers == null) {this.alertmanagers = new ArrayList<AlertmanagerEndpointsBuilder>();}
        AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);
        if (index < 0 || index >= _visitables.get("alertmanagers").size()) { _visitables.get("alertmanagers").add(builder); } else { _visitables.get("alertmanagers").set(index, builder);}
        if (index < 0 || index >= alertmanagers.size()) { alertmanagers.add(builder); } else { alertmanagers.set(index, builder);}
         return (A)this;
    }

    public A addToAlertmanagers(AlertmanagerEndpoints... items) {
        if (this.alertmanagers == null) {this.alertmanagers = new ArrayList<AlertmanagerEndpointsBuilder>();}
        for (AlertmanagerEndpoints item : items) {AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);_visitables.get("alertmanagers").add(builder);this.alertmanagers.add(builder);} return (A)this;
    }

    public A addAllToAlertmanagers(Collection<AlertmanagerEndpoints> items) {
        if (this.alertmanagers == null) {this.alertmanagers = new ArrayList<AlertmanagerEndpointsBuilder>();}
        for (AlertmanagerEndpoints item : items) {AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);_visitables.get("alertmanagers").add(builder);this.alertmanagers.add(builder);} return (A)this;
    }

    public A removeFromAlertmanagers(AlertmanagerEndpoints... items) {
        for (AlertmanagerEndpoints item : items) {AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);_visitables.get("alertmanagers").remove(builder);if (this.alertmanagers != null) {this.alertmanagers.remove(builder);}} return (A)this;
    }

    public A removeAllFromAlertmanagers(Collection<AlertmanagerEndpoints> items) {
        for (AlertmanagerEndpoints item : items) {AlertmanagerEndpointsBuilder builder = new AlertmanagerEndpointsBuilder(item);_visitables.get("alertmanagers").remove(builder);if (this.alertmanagers != null) {this.alertmanagers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAlertmanagers(io.fabric8.kubernetes.api.builder.Predicate<AlertmanagerEndpointsBuilder> predicate) {
        if (alertmanagers == null) return (A) this;
        final Iterator<AlertmanagerEndpointsBuilder> each = alertmanagers.iterator();
        final List visitables = _visitables.get("alertmanagers");
        while (each.hasNext()) {
          AlertmanagerEndpointsBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAlertmanagers instead.
 * @return The buildable object.
 */
@Deprecated public List<AlertmanagerEndpoints> getAlertmanagers() {
        return build(alertmanagers);
    }

    public List<AlertmanagerEndpoints> buildAlertmanagers() {
        return build(alertmanagers);
    }

    public AlertmanagerEndpoints buildAlertmanager(int index) {
        return this.alertmanagers.get(index).build();
    }

    public AlertmanagerEndpoints buildFirstAlertmanager() {
        return this.alertmanagers.get(0).build();
    }

    public AlertmanagerEndpoints buildLastAlertmanager() {
        return this.alertmanagers.get(alertmanagers.size() - 1).build();
    }

    public AlertmanagerEndpoints buildMatchingAlertmanager(io.fabric8.kubernetes.api.builder.Predicate<AlertmanagerEndpointsBuilder> predicate) {
        for (AlertmanagerEndpointsBuilder item: alertmanagers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAlertmanager(io.fabric8.kubernetes.api.builder.Predicate<AlertmanagerEndpointsBuilder> predicate) {
        for (AlertmanagerEndpointsBuilder item: alertmanagers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAlertmanagers(List<AlertmanagerEndpoints> alertmanagers) {
        if (this.alertmanagers != null) { _visitables.get("alertmanagers").removeAll(this.alertmanagers);}
        if (alertmanagers != null) {this.alertmanagers = new ArrayList<AlertmanagerEndpointsBuilder>(); for (AlertmanagerEndpoints item : alertmanagers){this.addToAlertmanagers(item);}} else { this.alertmanagers = null;} return (A) this;
    }

    public A withAlertmanagers(AlertmanagerEndpoints... alertmanagers) {
        if (this.alertmanagers != null) {this.alertmanagers.clear();}
        if (alertmanagers != null) {for (AlertmanagerEndpoints item :alertmanagers){ this.addToAlertmanagers(item);}} return (A) this;
    }

    public Boolean hasAlertmanagers() {
        return alertmanagers != null && !alertmanagers.isEmpty();
    }

    public AlertingSpecFluent.AlertmanagersNested<A> addNewAlertmanager() {
        return new AlertmanagersNestedImpl();
    }

    public AlertingSpecFluent.AlertmanagersNested<A> addNewAlertmanagerLike(AlertmanagerEndpoints item) {
        return new AlertmanagersNestedImpl(-1, item);
    }

    public AlertingSpecFluent.AlertmanagersNested<A> setNewAlertmanagerLike(int index,AlertmanagerEndpoints item) {
        return new AlertmanagersNestedImpl(index, item);
    }

    public AlertingSpecFluent.AlertmanagersNested<A> editAlertmanager(int index) {
        if (alertmanagers.size() <= index) throw new RuntimeException("Can't edit alertmanagers. Index exceeds size.");
        return setNewAlertmanagerLike(index, buildAlertmanager(index));
    }

    public AlertingSpecFluent.AlertmanagersNested<A> editFirstAlertmanager() {
        if (alertmanagers.size() == 0) throw new RuntimeException("Can't edit first alertmanagers. The list is empty.");
        return setNewAlertmanagerLike(0, buildAlertmanager(0));
    }

    public AlertingSpecFluent.AlertmanagersNested<A> editLastAlertmanager() {
        int index = alertmanagers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last alertmanagers. The list is empty.");
        return setNewAlertmanagerLike(index, buildAlertmanager(index));
    }

    public AlertingSpecFluent.AlertmanagersNested<A> editMatchingAlertmanager(io.fabric8.kubernetes.api.builder.Predicate<AlertmanagerEndpointsBuilder> predicate) {
        int index = -1;
        for (int i=0;i<alertmanagers.size();i++) { 
        if (predicate.apply(alertmanagers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching alertmanagers. No match found.");
        return setNewAlertmanagerLike(index, buildAlertmanager(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AlertingSpecFluentImpl that = (AlertingSpecFluentImpl) o;
        if (alertmanagers != null ? !alertmanagers.equals(that.alertmanagers) :that.alertmanagers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(alertmanagers,  super.hashCode());
    }

    public class AlertmanagersNestedImpl<N> extends AlertmanagerEndpointsFluentImpl<AlertingSpecFluent.AlertmanagersNested<N>> implements AlertingSpecFluent.AlertmanagersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AlertmanagerEndpointsBuilder builder;
        private final int index;

        AlertmanagersNestedImpl(int index,AlertmanagerEndpoints item) {
            this.index = index;
            this.builder = new AlertmanagerEndpointsBuilder(this, item);
        }

        AlertmanagersNestedImpl() {
            this.index = -1;
            this.builder = new AlertmanagerEndpointsBuilder(this);
        }

        public N and() {
             return (N) AlertingSpecFluentImpl.this.setToAlertmanagers(index,builder.build());
        }

        public N endAlertmanager() {
             return and();
        }
    }


}
