package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ThanosSpecBuilder extends ThanosSpecFluentImpl<ThanosSpecBuilder> implements VisitableBuilder<ThanosSpec,ThanosSpecBuilder>{

    ThanosSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ThanosSpecBuilder(){
            this(true);
    }
    public ThanosSpecBuilder(Boolean validationEnabled){
            this(new ThanosSpec(), validationEnabled);
    }
    public ThanosSpecBuilder(ThanosSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ThanosSpecBuilder(ThanosSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ThanosSpec(), validationEnabled);
    }
    public ThanosSpecBuilder(ThanosSpecFluent<?> fluent,ThanosSpec instance){
            this(fluent, instance, true);
    }
    public ThanosSpecBuilder(ThanosSpecFluent<?> fluent,ThanosSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBaseImage(instance.getBaseImage()); 
            fluent.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig()); 
            fluent.withImage(instance.getImage()); 
            fluent.withListenLocal(instance.getListenLocal()); 
            fluent.withLogFormat(instance.getLogFormat()); 
            fluent.withLogLevel(instance.getLogLevel()); 
            fluent.withMinTime(instance.getMinTime()); 
            fluent.withObjectStorageConfig(instance.getObjectStorageConfig()); 
            fluent.withResources(instance.getResources()); 
            fluent.withSha(instance.getSha()); 
            fluent.withTag(instance.getTag()); 
            fluent.withTracingConfig(instance.getTracingConfig()); 
            fluent.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }
    public ThanosSpecBuilder(ThanosSpec instance){
            this(instance,true);
    }
    public ThanosSpecBuilder(ThanosSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBaseImage(instance.getBaseImage()); 
            this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig()); 
            this.withImage(instance.getImage()); 
            this.withListenLocal(instance.getListenLocal()); 
            this.withLogFormat(instance.getLogFormat()); 
            this.withLogLevel(instance.getLogLevel()); 
            this.withMinTime(instance.getMinTime()); 
            this.withObjectStorageConfig(instance.getObjectStorageConfig()); 
            this.withResources(instance.getResources()); 
            this.withSha(instance.getSha()); 
            this.withTag(instance.getTag()); 
            this.withTracingConfig(instance.getTracingConfig()); 
            this.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }

    public ThanosSpec build(){
            ThanosSpec buildable = new ThanosSpec(fluent.getBaseImage(),fluent.getGrpcServerTlsConfig(),fluent.getImage(),fluent.isListenLocal(),fluent.getLogFormat(),fluent.getLogLevel(),fluent.getMinTime(),fluent.getObjectStorageConfig(),fluent.getResources(),fluent.getSha(),fluent.getTag(),fluent.getTracingConfig(),fluent.getVersion());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ThanosSpecBuilder that = (ThanosSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
