package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class StorageSpecFluentImpl<A extends StorageSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StorageSpecFluent<A>{

    private Boolean disableMountSubPath;
    private EmptyDirVolumeSource emptyDir;
    private EmbeddedPersistentVolumeClaimBuilder volumeClaimTemplate;

    public StorageSpecFluentImpl(){
    }
    public StorageSpecFluentImpl(StorageSpec instance){
            this.withDisableMountSubPath(instance.getDisableMountSubPath()); 
            this.withEmptyDir(instance.getEmptyDir()); 
            this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate()); 
    }

    public Boolean isDisableMountSubPath(){
            return this.disableMountSubPath;
    }

    public A withDisableMountSubPath(Boolean disableMountSubPath){
            this.disableMountSubPath=disableMountSubPath; return (A) this;
    }

    public Boolean hasDisableMountSubPath(){
            return this.disableMountSubPath != null;
    }

    public A withNewDisableMountSubPath(String arg1){
            return (A)withDisableMountSubPath(new Boolean(arg1));
    }

    public A withNewDisableMountSubPath(boolean arg1){
            return (A)withDisableMountSubPath(new Boolean(arg1));
    }

    public EmptyDirVolumeSource getEmptyDir(){
            return this.emptyDir;
    }

    public A withEmptyDir(EmptyDirVolumeSource emptyDir){
            this.emptyDir=emptyDir; return (A) this;
    }

    public Boolean hasEmptyDir(){
            return this.emptyDir != null;
    }

    
/**
 * This method has been deprecated, please use method buildVolumeClaimTemplate instead.
 * @return The buildable object.
 */
@Deprecated public EmbeddedPersistentVolumeClaim getVolumeClaimTemplate(){
            return this.volumeClaimTemplate!=null?this.volumeClaimTemplate.build():null;
    }

    public EmbeddedPersistentVolumeClaim buildVolumeClaimTemplate(){
            return this.volumeClaimTemplate!=null?this.volumeClaimTemplate.build():null;
    }

    public A withVolumeClaimTemplate(EmbeddedPersistentVolumeClaim volumeClaimTemplate){
            _visitables.get("volumeClaimTemplate").remove(this.volumeClaimTemplate);
            if (volumeClaimTemplate!=null){ this.volumeClaimTemplate= new EmbeddedPersistentVolumeClaimBuilder(volumeClaimTemplate); _visitables.get("volumeClaimTemplate").add(this.volumeClaimTemplate);} return (A) this;
    }

    public Boolean hasVolumeClaimTemplate(){
            return this.volumeClaimTemplate != null;
    }

    public StorageSpecFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplate(){
            return new VolumeClaimTemplateNestedImpl();
    }

    public StorageSpecFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplateLike(EmbeddedPersistentVolumeClaim item){
            return new VolumeClaimTemplateNestedImpl(item);
    }

    public StorageSpecFluent.VolumeClaimTemplateNested<A> editVolumeClaimTemplate(){
            return withNewVolumeClaimTemplateLike(getVolumeClaimTemplate());
    }

    public StorageSpecFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplate(){
            return withNewVolumeClaimTemplateLike(getVolumeClaimTemplate() != null ? getVolumeClaimTemplate(): new EmbeddedPersistentVolumeClaimBuilder().build());
    }

    public StorageSpecFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplateLike(EmbeddedPersistentVolumeClaim item){
            return withNewVolumeClaimTemplateLike(getVolumeClaimTemplate() != null ? getVolumeClaimTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            StorageSpecFluentImpl that = (StorageSpecFluentImpl) o;
            if (disableMountSubPath != null ? !disableMountSubPath.equals(that.disableMountSubPath) :that.disableMountSubPath != null) return false;
            if (emptyDir != null ? !emptyDir.equals(that.emptyDir) :that.emptyDir != null) return false;
            if (volumeClaimTemplate != null ? !volumeClaimTemplate.equals(that.volumeClaimTemplate) :that.volumeClaimTemplate != null) return false;
            return true;
    }


    public class VolumeClaimTemplateNestedImpl<N> extends EmbeddedPersistentVolumeClaimFluentImpl<StorageSpecFluent.VolumeClaimTemplateNested<N>> implements StorageSpecFluent.VolumeClaimTemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EmbeddedPersistentVolumeClaimBuilder builder;
    
            VolumeClaimTemplateNestedImpl(EmbeddedPersistentVolumeClaim item){
                    this.builder = new EmbeddedPersistentVolumeClaimBuilder(this, item);
            }
            VolumeClaimTemplateNestedImpl(){
                    this.builder = new EmbeddedPersistentVolumeClaimBuilder(this);
            }
    
    public N and(){
            return (N) StorageSpecFluentImpl.this.withVolumeClaimTemplate(builder.build());
    }
    public N endVolumeClaimTemplate(){
            return and();
    }

}


}
