package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;

public interface SecretOrConfigMapFluent<A extends SecretOrConfigMapFluent<A>> extends Fluent<A>{


    public ConfigMapKeySelector getConfigMap();
    public A withConfigMap(ConfigMapKeySelector configMap);
    public Boolean hasConfigMap();
    public A withNewConfigMap(String key,String name,Boolean optional);
    public SecretKeySelector getSecret();
    public A withSecret(SecretKeySelector secret);
    public Boolean hasSecret();
    public A withNewSecret(String key,String name,Boolean optional);



}
