package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RemoteWriteSpecBuilder extends RemoteWriteSpecFluentImpl<RemoteWriteSpecBuilder> implements VisitableBuilder<RemoteWriteSpec,RemoteWriteSpecBuilder>{

    RemoteWriteSpecFluent<?> fluent;
    Boolean validationEnabled;

    public RemoteWriteSpecBuilder(){
            this(true);
    }
    public RemoteWriteSpecBuilder(Boolean validationEnabled){
            this(new RemoteWriteSpec(), validationEnabled);
    }
    public RemoteWriteSpecBuilder(RemoteWriteSpecFluent<?> fluent){
            this(fluent, true);
    }
    public RemoteWriteSpecBuilder(RemoteWriteSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RemoteWriteSpec(), validationEnabled);
    }
    public RemoteWriteSpecBuilder(RemoteWriteSpecFluent<?> fluent,RemoteWriteSpec instance){
            this(fluent, instance, true);
    }
    public RemoteWriteSpecBuilder(RemoteWriteSpecFluent<?> fluent,RemoteWriteSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBasicAuth(instance.getBasicAuth()); 
            fluent.withBearerToken(instance.getBearerToken()); 
            fluent.withBearerTokenFile(instance.getBearerTokenFile()); 
            fluent.withName(instance.getName()); 
            fluent.withProxyUrl(instance.getProxyUrl()); 
            fluent.withQueueConfig(instance.getQueueConfig()); 
            fluent.withRemoteTimeout(instance.getRemoteTimeout()); 
            fluent.withTlsConfig(instance.getTlsConfig()); 
            fluent.withUrl(instance.getUrl()); 
            fluent.withWriteRelabelConfigs(instance.getWriteRelabelConfigs()); 
            this.validationEnabled = validationEnabled; 
    }
    public RemoteWriteSpecBuilder(RemoteWriteSpec instance){
            this(instance,true);
    }
    public RemoteWriteSpecBuilder(RemoteWriteSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBasicAuth(instance.getBasicAuth()); 
            this.withBearerToken(instance.getBearerToken()); 
            this.withBearerTokenFile(instance.getBearerTokenFile()); 
            this.withName(instance.getName()); 
            this.withProxyUrl(instance.getProxyUrl()); 
            this.withQueueConfig(instance.getQueueConfig()); 
            this.withRemoteTimeout(instance.getRemoteTimeout()); 
            this.withTlsConfig(instance.getTlsConfig()); 
            this.withUrl(instance.getUrl()); 
            this.withWriteRelabelConfigs(instance.getWriteRelabelConfigs()); 
            this.validationEnabled = validationEnabled; 
    }

    public RemoteWriteSpec build(){
            RemoteWriteSpec buildable = new RemoteWriteSpec(fluent.getBasicAuth(),fluent.getBearerToken(),fluent.getBearerTokenFile(),fluent.getName(),fluent.getProxyUrl(),fluent.getQueueConfig(),fluent.getRemoteTimeout(),fluent.getTlsConfig(),fluent.getUrl(),fluent.getWriteRelabelConfigs());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RemoteWriteSpecBuilder that = (RemoteWriteSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
