package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;

public class PrometheusFluentImpl<A extends PrometheusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PrometheusFluent<A>{

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private PrometheusSpecBuilder spec;
    private PrometheusStatusBuilder status;

    public PrometheusFluentImpl(){
    }
    public PrometheusFluentImpl(Prometheus instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public PrometheusFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public PrometheusFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public PrometheusFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public PrometheusFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public PrometheusFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public PrometheusSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public PrometheusSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(PrometheusSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new PrometheusSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public PrometheusFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public PrometheusFluent.SpecNested<A> withNewSpecLike(PrometheusSpec item){
            return new SpecNestedImpl(item);
    }

    public PrometheusFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public PrometheusFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new PrometheusSpecBuilder().build());
    }

    public PrometheusFluent.SpecNested<A> editOrNewSpecLike(PrometheusSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public PrometheusStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public PrometheusStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(PrometheusStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new PrometheusStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public A withNewStatus(Integer availableReplicas,Boolean paused,Integer replicas,Integer unavailableReplicas,Integer updatedReplicas){
            return (A)withStatus(new PrometheusStatus(availableReplicas, paused, replicas, unavailableReplicas, updatedReplicas));
    }

    public PrometheusFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public PrometheusFluent.StatusNested<A> withNewStatusLike(PrometheusStatus item){
            return new StatusNestedImpl(item);
    }

    public PrometheusFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public PrometheusFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new PrometheusStatusBuilder().build());
    }

    public PrometheusFluent.StatusNested<A> editOrNewStatusLike(PrometheusStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PrometheusFluentImpl that = (PrometheusFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PrometheusFluent.MetadataNested<N>> implements PrometheusFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) PrometheusFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends PrometheusSpecFluentImpl<PrometheusFluent.SpecNested<N>> implements PrometheusFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PrometheusSpecBuilder builder;
    
            SpecNestedImpl(PrometheusSpec item){
                    this.builder = new PrometheusSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new PrometheusSpecBuilder(this);
            }
    
    public N and(){
            return (N) PrometheusFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends PrometheusStatusFluentImpl<PrometheusFluent.StatusNested<N>> implements PrometheusFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PrometheusStatusBuilder builder;
    
            StatusNestedImpl(PrometheusStatus item){
                    this.builder = new PrometheusStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new PrometheusStatusBuilder(this);
            }
    
    public N and(){
            return (N) PrometheusFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
