package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ArbitraryFSAccessThroughSMsConfigBuilder extends ArbitraryFSAccessThroughSMsConfigFluentImpl<ArbitraryFSAccessThroughSMsConfigBuilder> implements VisitableBuilder<ArbitraryFSAccessThroughSMsConfig,ArbitraryFSAccessThroughSMsConfigBuilder>{

    ArbitraryFSAccessThroughSMsConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ArbitraryFSAccessThroughSMsConfigBuilder(){
            this(true);
    }
    public ArbitraryFSAccessThroughSMsConfigBuilder(Boolean validationEnabled){
            this(new ArbitraryFSAccessThroughSMsConfig(), validationEnabled);
    }
    public ArbitraryFSAccessThroughSMsConfigBuilder(ArbitraryFSAccessThroughSMsConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ArbitraryFSAccessThroughSMsConfigBuilder(ArbitraryFSAccessThroughSMsConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ArbitraryFSAccessThroughSMsConfig(), validationEnabled);
    }
    public ArbitraryFSAccessThroughSMsConfigBuilder(ArbitraryFSAccessThroughSMsConfigFluent<?> fluent,ArbitraryFSAccessThroughSMsConfig instance){
            this(fluent, instance, true);
    }
    public ArbitraryFSAccessThroughSMsConfigBuilder(ArbitraryFSAccessThroughSMsConfigFluent<?> fluent,ArbitraryFSAccessThroughSMsConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDeny(instance.getDeny()); 
            this.validationEnabled = validationEnabled; 
    }
    public ArbitraryFSAccessThroughSMsConfigBuilder(ArbitraryFSAccessThroughSMsConfig instance){
            this(instance,true);
    }
    public ArbitraryFSAccessThroughSMsConfigBuilder(ArbitraryFSAccessThroughSMsConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDeny(instance.getDeny()); 
            this.validationEnabled = validationEnabled; 
    }

    public ArbitraryFSAccessThroughSMsConfig build(){
            ArbitraryFSAccessThroughSMsConfig buildable = new ArbitraryFSAccessThroughSMsConfig(fluent.isDeny());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ArbitraryFSAccessThroughSMsConfigBuilder that = (ArbitraryFSAccessThroughSMsConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
