package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import com.fasterxml.jackson.core.JsonParser;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;

public class AlertmanagerEndpointsFluentImpl<A extends AlertmanagerEndpointsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AlertmanagerEndpointsFluent<A>{

    private String apiVersion;
    private String bearerTokenFile;
    private String name;
    private String namespace;
    private String pathPrefix;
    private IntOrStringBuilder port;
    private String scheme;
    private TLSConfigBuilder tlsConfig;

    public AlertmanagerEndpointsFluentImpl(){
    }
    public AlertmanagerEndpointsFluentImpl(AlertmanagerEndpoints instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withBearerTokenFile(instance.getBearerTokenFile()); 
            this.withName(instance.getName()); 
            this.withNamespace(instance.getNamespace()); 
            this.withPathPrefix(instance.getPathPrefix()); 
            this.withPort(instance.getPort()); 
            this.withScheme(instance.getScheme()); 
            this.withTlsConfig(instance.getTlsConfig()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getBearerTokenFile(){
            return this.bearerTokenFile;
    }

    public A withBearerTokenFile(String bearerTokenFile){
            this.bearerTokenFile=bearerTokenFile; return (A) this;
    }

    public Boolean hasBearerTokenFile(){
            return this.bearerTokenFile != null;
    }

    public A withNewBearerTokenFile(String arg1){
            return (A)withBearerTokenFile(new String(arg1));
    }

    public A withNewBearerTokenFile(StringBuilder arg1){
            return (A)withBearerTokenFile(new String(arg1));
    }

    public A withNewBearerTokenFile(StringBuffer arg1){
            return (A)withBearerTokenFile(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getNamespace(){
            return this.namespace;
    }

    public A withNamespace(String namespace){
            this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace(){
            return this.namespace != null;
    }

    public A withNewNamespace(String arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1){
            return (A)withNamespace(new String(arg1));
    }

    public String getPathPrefix(){
            return this.pathPrefix;
    }

    public A withPathPrefix(String pathPrefix){
            this.pathPrefix=pathPrefix; return (A) this;
    }

    public Boolean hasPathPrefix(){
            return this.pathPrefix != null;
    }

    public A withNewPathPrefix(String arg1){
            return (A)withPathPrefix(new String(arg1));
    }

    public A withNewPathPrefix(StringBuilder arg1){
            return (A)withPathPrefix(new String(arg1));
    }

    public A withNewPathPrefix(StringBuffer arg1){
            return (A)withPathPrefix(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPort instead.
 * @return The buildable object.
 */
@Deprecated public IntOrString getPort(){
            return this.port!=null?this.port.build():null;
    }

    public IntOrString buildPort(){
            return this.port!=null?this.port.build():null;
    }

    public A withPort(IntOrString port){
            _visitables.get("port").remove(this.port);
            if (port!=null){ this.port= new IntOrStringBuilder(port); _visitables.get("port").add(this.port);} return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A withNewPort(String strVal){
            return (A)withPort(new IntOrString(strVal));
    }

    public A withNewPort(Integer intVal){
            return (A)withPort(new IntOrString(intVal));
    }

    public AlertmanagerEndpointsFluent.PortNested<A> withNewPort(){
            return new PortNestedImpl();
    }

    public AlertmanagerEndpointsFluent.PortNested<A> withNewPortLike(IntOrString item){
            return new PortNestedImpl(item);
    }

    public AlertmanagerEndpointsFluent.PortNested<A> editPort(){
            return withNewPortLike(getPort());
    }

    public AlertmanagerEndpointsFluent.PortNested<A> editOrNewPort(){
            return withNewPortLike(getPort() != null ? getPort(): new IntOrStringBuilder().build());
    }

    public AlertmanagerEndpointsFluent.PortNested<A> editOrNewPortLike(IntOrString item){
            return withNewPortLike(getPort() != null ? getPort(): item);
    }

    public String getScheme(){
            return this.scheme;
    }

    public A withScheme(String scheme){
            this.scheme=scheme; return (A) this;
    }

    public Boolean hasScheme(){
            return this.scheme != null;
    }

    public A withNewScheme(String arg1){
            return (A)withScheme(new String(arg1));
    }

    public A withNewScheme(StringBuilder arg1){
            return (A)withScheme(new String(arg1));
    }

    public A withNewScheme(StringBuffer arg1){
            return (A)withScheme(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTlsConfig instead.
 * @return The buildable object.
 */
@Deprecated public TLSConfig getTlsConfig(){
            return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public TLSConfig buildTlsConfig(){
            return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public A withTlsConfig(TLSConfig tlsConfig){
            _visitables.get("tlsConfig").remove(this.tlsConfig);
            if (tlsConfig!=null){ this.tlsConfig= new TLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} return (A) this;
    }

    public Boolean hasTlsConfig(){
            return this.tlsConfig != null;
    }

    public AlertmanagerEndpointsFluent.TlsConfigNested<A> withNewTlsConfig(){
            return new TlsConfigNestedImpl();
    }

    public AlertmanagerEndpointsFluent.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item){
            return new TlsConfigNestedImpl(item);
    }

    public AlertmanagerEndpointsFluent.TlsConfigNested<A> editTlsConfig(){
            return withNewTlsConfigLike(getTlsConfig());
    }

    public AlertmanagerEndpointsFluent.TlsConfigNested<A> editOrNewTlsConfig(){
            return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new TLSConfigBuilder().build());
    }

    public AlertmanagerEndpointsFluent.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item){
            return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            AlertmanagerEndpointsFluentImpl that = (AlertmanagerEndpointsFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (bearerTokenFile != null ? !bearerTokenFile.equals(that.bearerTokenFile) :that.bearerTokenFile != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
            if (pathPrefix != null ? !pathPrefix.equals(that.pathPrefix) :that.pathPrefix != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
            if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
            return true;
    }


    public class PortNestedImpl<N> extends IntOrStringFluentImpl<AlertmanagerEndpointsFluent.PortNested<N>> implements AlertmanagerEndpointsFluent.PortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IntOrStringBuilder builder;
    
            PortNestedImpl(IntOrString item){
                    this.builder = new IntOrStringBuilder(this, item);
            }
            PortNestedImpl(){
                    this.builder = new IntOrStringBuilder(this);
            }
    
    public N and(){
            return (N) AlertmanagerEndpointsFluentImpl.this.withPort(builder.build());
    }
    public N endPort(){
            return and();
    }

}
    public class TlsConfigNestedImpl<N> extends TLSConfigFluentImpl<AlertmanagerEndpointsFluent.TlsConfigNested<N>> implements AlertmanagerEndpointsFluent.TlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TLSConfigBuilder builder;
    
            TlsConfigNestedImpl(TLSConfig item){
                    this.builder = new TLSConfigBuilder(this, item);
            }
            TlsConfigNestedImpl(){
                    this.builder = new TLSConfigBuilder(this);
            }
    
    public N and(){
            return (N) AlertmanagerEndpointsFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig(){
            return and();
    }

}


}
