package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AlertmanagerBuilder extends AlertmanagerFluentImpl<AlertmanagerBuilder> implements VisitableBuilder<Alertmanager,AlertmanagerBuilder>{

    AlertmanagerFluent<?> fluent;
    Boolean validationEnabled;

    public AlertmanagerBuilder(){
            this(true);
    }
    public AlertmanagerBuilder(Boolean validationEnabled){
            this(new Alertmanager(), validationEnabled);
    }
    public AlertmanagerBuilder(AlertmanagerFluent<?> fluent){
            this(fluent, true);
    }
    public AlertmanagerBuilder(AlertmanagerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Alertmanager(), validationEnabled);
    }
    public AlertmanagerBuilder(AlertmanagerFluent<?> fluent,Alertmanager instance){
            this(fluent, instance, true);
    }
    public AlertmanagerBuilder(AlertmanagerFluent<?> fluent,Alertmanager instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public AlertmanagerBuilder(Alertmanager instance){
            this(instance,true);
    }
    public AlertmanagerBuilder(Alertmanager instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public Alertmanager build(){
            Alertmanager buildable = new Alertmanager(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AlertmanagerBuilder that = (AlertmanagerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
