package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceMonitorSpecBuilder extends ServiceMonitorSpecFluentImpl<ServiceMonitorSpecBuilder> implements VisitableBuilder<ServiceMonitorSpec,ServiceMonitorSpecBuilder>{

    ServiceMonitorSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceMonitorSpecBuilder(){
            this(true);
    }
    public ServiceMonitorSpecBuilder(Boolean validationEnabled){
            this(new ServiceMonitorSpec(), validationEnabled);
    }
    public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceMonitorSpec(), validationEnabled);
    }
    public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,ServiceMonitorSpec instance){
            this(fluent, instance, true);
    }
    public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,ServiceMonitorSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEndpoints(instance.getEndpoints()); 
            fluent.withJobLabel(instance.getJobLabel()); 
            fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
            fluent.withPodTargetLabels(instance.getPodTargetLabels()); 
            fluent.withSampleLimit(instance.getSampleLimit()); 
            fluent.withSelector(instance.getSelector()); 
            fluent.withTargetLabels(instance.getTargetLabels()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceMonitorSpecBuilder(ServiceMonitorSpec instance){
            this(instance,true);
    }
    public ServiceMonitorSpecBuilder(ServiceMonitorSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEndpoints(instance.getEndpoints()); 
            this.withJobLabel(instance.getJobLabel()); 
            this.withNamespaceSelector(instance.getNamespaceSelector()); 
            this.withPodTargetLabels(instance.getPodTargetLabels()); 
            this.withSampleLimit(instance.getSampleLimit()); 
            this.withSelector(instance.getSelector()); 
            this.withTargetLabels(instance.getTargetLabels()); 
            this.validationEnabled = validationEnabled; 
    }

    public ServiceMonitorSpec build(){
            ServiceMonitorSpec buildable = new ServiceMonitorSpec(fluent.getEndpoints(),fluent.getJobLabel(),fluent.getNamespaceSelector(),fluent.getPodTargetLabels(),fluent.getSampleLimit(),fluent.getSelector(),fluent.getTargetLabels());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceMonitorSpecBuilder that = (ServiceMonitorSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
