package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ServiceMonitorFluent<A extends ServiceMonitorFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ServiceMonitorFluent.MetadataNested<A> withNewMetadata();
    public ServiceMonitorFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ServiceMonitorFluent.MetadataNested<A> editMetadata();
    public ServiceMonitorFluent.MetadataNested<A> editOrNewMetadata();
    public ServiceMonitorFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ServiceMonitorSpec getSpec();
    public ServiceMonitorSpec buildSpec();
    public A withSpec(ServiceMonitorSpec spec);
    public Boolean hasSpec();
    public ServiceMonitorFluent.SpecNested<A> withNewSpec();
    public ServiceMonitorFluent.SpecNested<A> withNewSpecLike(ServiceMonitorSpec item);
    public ServiceMonitorFluent.SpecNested<A> editSpec();
    public ServiceMonitorFluent.SpecNested<A> editOrNewSpec();
    public ServiceMonitorFluent.SpecNested<A> editOrNewSpecLike(ServiceMonitorSpec item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ServiceMonitorFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceMonitorSpecFluent<ServiceMonitorFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
