package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RulesBuilder extends RulesFluentImpl<RulesBuilder> implements VisitableBuilder<Rules,RulesBuilder>{

    RulesFluent<?> fluent;
    Boolean validationEnabled;

    public RulesBuilder(){
            this(true);
    }
    public RulesBuilder(Boolean validationEnabled){
            this(new Rules(), validationEnabled);
    }
    public RulesBuilder(RulesFluent<?> fluent){
            this(fluent, true);
    }
    public RulesBuilder(RulesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Rules(), validationEnabled);
    }
    public RulesBuilder(RulesFluent<?> fluent,Rules instance){
            this(fluent, instance, true);
    }
    public RulesBuilder(RulesFluent<?> fluent,Rules instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAlert(instance.getAlert()); 
            this.validationEnabled = validationEnabled; 
    }
    public RulesBuilder(Rules instance){
            this(instance,true);
    }
    public RulesBuilder(Rules instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAlert(instance.getAlert()); 
            this.validationEnabled = validationEnabled; 
    }

    public Rules build(){
            Rules buildable = new Rules(fluent.getAlert());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RulesBuilder that = (RulesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
