package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import com.fasterxml.jackson.core.JsonParser;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.util.Map;

public class RuleFluentImpl<A extends RuleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RuleFluent<A>{

    private String alert;
    private Map<String,String> annotations;
    private IntOrStringBuilder expr;
    private String _for;
    private Map<String,String> labels;
    private String record;

    public RuleFluentImpl(){
    }
    public RuleFluentImpl(Rule instance){
            this.withAlert(instance.getAlert()); 
            this.withAnnotations(instance.getAnnotations()); 
            this.withExpr(instance.getExpr()); 
            this.withFor(instance.getFor()); 
            this.withLabels(instance.getLabels()); 
            this.withRecord(instance.getRecord()); 
    }

    public String getAlert(){
            return this.alert;
    }

    public A withAlert(String alert){
            this.alert=alert; return (A) this;
    }

    public Boolean hasAlert(){
            return this.alert != null;
    }

    public A withNewAlert(String arg1){
            return (A)withAlert(new String(arg1));
    }

    public A withNewAlert(StringBuilder arg1){
            return (A)withAlert(new String(arg1));
    }

    public A withNewAlert(StringBuffer arg1){
            return (A)withAlert(new String(arg1));
    }

    public A addToAnnotations(String key,String value){
            if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(Map<String,String> map){
            if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
            if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key){
            if(this.annotations == null) { return (A) this; }
            if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(Map<String,String> map){
            if(this.annotations == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAnnotations(){
            return this.annotations;
    }

    public A withAnnotations(Map<String,String> annotations){
            if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations(){
            return this.annotations != null;
    }

    
/**
 * This method has been deprecated, please use method buildExpr instead.
 * @return The buildable object.
 */
@Deprecated public IntOrString getExpr(){
            return this.expr!=null?this.expr.build():null;
    }

    public IntOrString buildExpr(){
            return this.expr!=null?this.expr.build():null;
    }

    public A withExpr(IntOrString expr){
            _visitables.get("expr").remove(this.expr);
            if (expr!=null){ this.expr= new IntOrStringBuilder(expr); _visitables.get("expr").add(this.expr);} return (A) this;
    }

    public Boolean hasExpr(){
            return this.expr != null;
    }

    public A withNewExpr(String strVal){
            return (A)withExpr(new IntOrString(strVal));
    }

    public A withNewExpr(Integer intVal){
            return (A)withExpr(new IntOrString(intVal));
    }

    public RuleFluent.ExprNested<A> withNewExpr(){
            return new ExprNestedImpl();
    }

    public RuleFluent.ExprNested<A> withNewExprLike(IntOrString item){
            return new ExprNestedImpl(item);
    }

    public RuleFluent.ExprNested<A> editExpr(){
            return withNewExprLike(getExpr());
    }

    public RuleFluent.ExprNested<A> editOrNewExpr(){
            return withNewExprLike(getExpr() != null ? getExpr(): new IntOrStringBuilder().build());
    }

    public RuleFluent.ExprNested<A> editOrNewExprLike(IntOrString item){
            return withNewExprLike(getExpr() != null ? getExpr(): item);
    }

    public String getFor(){
            return this._for;
    }

    public A withFor(String _for){
            this._for=_for; return (A) this;
    }

    public Boolean hasFor(){
            return this._for != null;
    }

    public A withNewFor(String arg1){
            return (A)withFor(new String(arg1));
    }

    public A withNewFor(StringBuilder arg1){
            return (A)withFor(new String(arg1));
    }

    public A withNewFor(StringBuffer arg1){
            return (A)withFor(new String(arg1));
    }

    public A addToLabels(String key,String value){
            if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map){
            if(this.labels == null && map != null) { this.labels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key){
            if(this.labels == null) { return (A) this; }
            if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map){
            if(this.labels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getLabels(){
            return this.labels;
    }

    public A withLabels(Map<String,String> labels){
            if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap<String,String>(labels);} return (A) this;
    }

    public Boolean hasLabels(){
            return this.labels != null;
    }

    public String getRecord(){
            return this.record;
    }

    public A withRecord(String record){
            this.record=record; return (A) this;
    }

    public Boolean hasRecord(){
            return this.record != null;
    }

    public A withNewRecord(String arg1){
            return (A)withRecord(new String(arg1));
    }

    public A withNewRecord(StringBuilder arg1){
            return (A)withRecord(new String(arg1));
    }

    public A withNewRecord(StringBuffer arg1){
            return (A)withRecord(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            RuleFluentImpl that = (RuleFluentImpl) o;
            if (alert != null ? !alert.equals(that.alert) :that.alert != null) return false;
            if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
            if (expr != null ? !expr.equals(that.expr) :that.expr != null) return false;
            if (_for != null ? !_for.equals(that._for) :that._for != null) return false;
            if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
            if (record != null ? !record.equals(that.record) :that.record != null) return false;
            return true;
    }


    public class ExprNestedImpl<N> extends IntOrStringFluentImpl<RuleFluent.ExprNested<N>> implements RuleFluent.ExprNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IntOrStringBuilder builder;
    
            ExprNestedImpl(IntOrString item){
                    this.builder = new IntOrStringBuilder(this, item);
            }
            ExprNestedImpl(){
                    this.builder = new IntOrStringBuilder(this);
            }
    
    public N and(){
            return (N) RuleFluentImpl.this.withExpr(builder.build());
    }
    public N endExpr(){
            return and();
    }

}


}
