package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RemoteReadSpecBuilder extends RemoteReadSpecFluentImpl<RemoteReadSpecBuilder> implements VisitableBuilder<RemoteReadSpec,RemoteReadSpecBuilder>{

    RemoteReadSpecFluent<?> fluent;
    Boolean validationEnabled;

    public RemoteReadSpecBuilder(){
            this(true);
    }
    public RemoteReadSpecBuilder(Boolean validationEnabled){
            this(new RemoteReadSpec(), validationEnabled);
    }
    public RemoteReadSpecBuilder(RemoteReadSpecFluent<?> fluent){
            this(fluent, true);
    }
    public RemoteReadSpecBuilder(RemoteReadSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RemoteReadSpec(), validationEnabled);
    }
    public RemoteReadSpecBuilder(RemoteReadSpecFluent<?> fluent,RemoteReadSpec instance){
            this(fluent, instance, true);
    }
    public RemoteReadSpecBuilder(RemoteReadSpecFluent<?> fluent,RemoteReadSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBasicAuth(instance.getBasicAuth()); 
            fluent.withBearerToken(instance.getBearerToken()); 
            fluent.withBearerTokenFile(instance.getBearerTokenFile()); 
            fluent.withName(instance.getName()); 
            fluent.withProxyUrl(instance.getProxyUrl()); 
            fluent.withReadRecent(instance.getReadRecent()); 
            fluent.withRemoteTimeout(instance.getRemoteTimeout()); 
            fluent.withRequiredMatchers(instance.getRequiredMatchers()); 
            fluent.withTlsConfig(instance.getTlsConfig()); 
            fluent.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public RemoteReadSpecBuilder(RemoteReadSpec instance){
            this(instance,true);
    }
    public RemoteReadSpecBuilder(RemoteReadSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBasicAuth(instance.getBasicAuth()); 
            this.withBearerToken(instance.getBearerToken()); 
            this.withBearerTokenFile(instance.getBearerTokenFile()); 
            this.withName(instance.getName()); 
            this.withProxyUrl(instance.getProxyUrl()); 
            this.withReadRecent(instance.getReadRecent()); 
            this.withRemoteTimeout(instance.getRemoteTimeout()); 
            this.withRequiredMatchers(instance.getRequiredMatchers()); 
            this.withTlsConfig(instance.getTlsConfig()); 
            this.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public RemoteReadSpec build(){
            RemoteReadSpec buildable = new RemoteReadSpec(fluent.getBasicAuth(),fluent.getBearerToken(),fluent.getBearerTokenFile(),fluent.getName(),fluent.getProxyUrl(),fluent.isReadRecent(),fluent.getRemoteTimeout(),fluent.getRequiredMatchers(),fluent.getTlsConfig(),fluent.getUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RemoteReadSpecBuilder that = (RemoteReadSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
