package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RelabelConfigBuilder extends RelabelConfigFluentImpl<RelabelConfigBuilder> implements VisitableBuilder<RelabelConfig,RelabelConfigBuilder>{

    RelabelConfigFluent<?> fluent;
    Boolean validationEnabled;

    public RelabelConfigBuilder(){
            this(true);
    }
    public RelabelConfigBuilder(Boolean validationEnabled){
            this(new RelabelConfig(), validationEnabled);
    }
    public RelabelConfigBuilder(RelabelConfigFluent<?> fluent){
            this(fluent, true);
    }
    public RelabelConfigBuilder(RelabelConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RelabelConfig(), validationEnabled);
    }
    public RelabelConfigBuilder(RelabelConfigFluent<?> fluent,RelabelConfig instance){
            this(fluent, instance, true);
    }
    public RelabelConfigBuilder(RelabelConfigFluent<?> fluent,RelabelConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAction(instance.getAction()); 
            fluent.withModulus(instance.getModulus()); 
            fluent.withRegex(instance.getRegex()); 
            fluent.withReplacement(instance.getReplacement()); 
            fluent.withSeparator(instance.getSeparator()); 
            fluent.withSourceLabels(instance.getSourceLabels()); 
            fluent.withTargetLabel(instance.getTargetLabel()); 
            this.validationEnabled = validationEnabled; 
    }
    public RelabelConfigBuilder(RelabelConfig instance){
            this(instance,true);
    }
    public RelabelConfigBuilder(RelabelConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAction(instance.getAction()); 
            this.withModulus(instance.getModulus()); 
            this.withRegex(instance.getRegex()); 
            this.withReplacement(instance.getReplacement()); 
            this.withSeparator(instance.getSeparator()); 
            this.withSourceLabels(instance.getSourceLabels()); 
            this.withTargetLabel(instance.getTargetLabel()); 
            this.validationEnabled = validationEnabled; 
    }

    public RelabelConfig build(){
            RelabelConfig buildable = new RelabelConfig(fluent.getAction(),fluent.getModulus(),fluent.getRegex(),fluent.getReplacement(),fluent.getSeparator(),fluent.getSourceLabels(),fluent.getTargetLabel());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RelabelConfigBuilder that = (RelabelConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
