package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrometheusStatusBuilder extends PrometheusStatusFluentImpl<PrometheusStatusBuilder> implements VisitableBuilder<PrometheusStatus,PrometheusStatusBuilder>{

    PrometheusStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PrometheusStatusBuilder(){
            this(true);
    }
    public PrometheusStatusBuilder(Boolean validationEnabled){
            this(new PrometheusStatus(), validationEnabled);
    }
    public PrometheusStatusBuilder(PrometheusStatusFluent<?> fluent){
            this(fluent, true);
    }
    public PrometheusStatusBuilder(PrometheusStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PrometheusStatus(), validationEnabled);
    }
    public PrometheusStatusBuilder(PrometheusStatusFluent<?> fluent,PrometheusStatus instance){
            this(fluent, instance, true);
    }
    public PrometheusStatusBuilder(PrometheusStatusFluent<?> fluent,PrometheusStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
            fluent.withPaused(instance.getPaused()); 
            fluent.withReplicas(instance.getReplicas()); 
            fluent.withUnavailableReplicas(instance.getUnavailableReplicas()); 
            fluent.withUpdatedReplicas(instance.getUpdatedReplicas()); 
            this.validationEnabled = validationEnabled; 
    }
    public PrometheusStatusBuilder(PrometheusStatus instance){
            this(instance,true);
    }
    public PrometheusStatusBuilder(PrometheusStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAvailableReplicas(instance.getAvailableReplicas()); 
            this.withPaused(instance.getPaused()); 
            this.withReplicas(instance.getReplicas()); 
            this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
            this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
            this.validationEnabled = validationEnabled; 
    }

    public PrometheusStatus build(){
            PrometheusStatus buildable = new PrometheusStatus(fluent.getAvailableReplicas(),fluent.isPaused(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PrometheusStatusBuilder that = (PrometheusStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
