package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrometheusRuleListBuilder extends PrometheusRuleListFluentImpl<PrometheusRuleListBuilder> implements VisitableBuilder<PrometheusRuleList,PrometheusRuleListBuilder>{

    PrometheusRuleListFluent<?> fluent;
    Boolean validationEnabled;

    public PrometheusRuleListBuilder(){
            this(true);
    }
    public PrometheusRuleListBuilder(Boolean validationEnabled){
            this(new PrometheusRuleList(), validationEnabled);
    }
    public PrometheusRuleListBuilder(PrometheusRuleListFluent<?> fluent){
            this(fluent, true);
    }
    public PrometheusRuleListBuilder(PrometheusRuleListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PrometheusRuleList(), validationEnabled);
    }
    public PrometheusRuleListBuilder(PrometheusRuleListFluent<?> fluent,PrometheusRuleList instance){
            this(fluent, instance, true);
    }
    public PrometheusRuleListBuilder(PrometheusRuleListFluent<?> fluent,PrometheusRuleList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public PrometheusRuleListBuilder(PrometheusRuleList instance){
            this(instance,true);
    }
    public PrometheusRuleListBuilder(PrometheusRuleList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public PrometheusRuleList build(){
            PrometheusRuleList buildable = new PrometheusRuleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PrometheusRuleListBuilder that = (PrometheusRuleListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
