package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrometheusRuleBuilder extends PrometheusRuleFluentImpl<PrometheusRuleBuilder> implements VisitableBuilder<PrometheusRule,PrometheusRuleBuilder>{

    PrometheusRuleFluent<?> fluent;
    Boolean validationEnabled;

    public PrometheusRuleBuilder(){
            this(true);
    }
    public PrometheusRuleBuilder(Boolean validationEnabled){
            this(new PrometheusRule(), validationEnabled);
    }
    public PrometheusRuleBuilder(PrometheusRuleFluent<?> fluent){
            this(fluent, true);
    }
    public PrometheusRuleBuilder(PrometheusRuleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PrometheusRule(), validationEnabled);
    }
    public PrometheusRuleBuilder(PrometheusRuleFluent<?> fluent,PrometheusRule instance){
            this(fluent, instance, true);
    }
    public PrometheusRuleBuilder(PrometheusRuleFluent<?> fluent,PrometheusRule instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public PrometheusRuleBuilder(PrometheusRule instance){
            this(instance,true);
    }
    public PrometheusRuleBuilder(PrometheusRule instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public PrometheusRule build(){
            PrometheusRule buildable = new PrometheusRule(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PrometheusRuleBuilder that = (PrometheusRuleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
