package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.lang.Deprecated;
import java.util.Iterator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.core.JsonParser;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;

public class EndpointFluentImpl<A extends EndpointFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EndpointFluent<A>{

    private BasicAuthBuilder basicAuth;
    private String bearerTokenFile;
    private SecretKeySelector bearerTokenSecret;
    private Boolean honorLabels;
    private Boolean honorTimestamps;
    private String interval;
    private List<RelabelConfigBuilder> metricRelabelings =  new ArrayList<RelabelConfigBuilder>();
    private Map<String,ArrayList<String>> params;
    private String path;
    private String port;
    private String proxyUrl;
    private List<RelabelConfigBuilder> relabelings =  new ArrayList<RelabelConfigBuilder>();
    private String scheme;
    private String scrapeTimeout;
    private IntOrStringBuilder targetPort;
    private TLSConfigBuilder tlsConfig;

    public EndpointFluentImpl(){
    }
    public EndpointFluentImpl(Endpoint instance){
            this.withBasicAuth(instance.getBasicAuth()); 
            this.withBearerTokenFile(instance.getBearerTokenFile()); 
            this.withBearerTokenSecret(instance.getBearerTokenSecret()); 
            this.withHonorLabels(instance.getHonorLabels()); 
            this.withHonorTimestamps(instance.getHonorTimestamps()); 
            this.withInterval(instance.getInterval()); 
            this.withMetricRelabelings(instance.getMetricRelabelings()); 
            this.withParams(instance.getParams()); 
            this.withPath(instance.getPath()); 
            this.withPort(instance.getPort()); 
            this.withProxyUrl(instance.getProxyUrl()); 
            this.withRelabelings(instance.getRelabelings()); 
            this.withScheme(instance.getScheme()); 
            this.withScrapeTimeout(instance.getScrapeTimeout()); 
            this.withTargetPort(instance.getTargetPort()); 
            this.withTlsConfig(instance.getTlsConfig()); 
    }

    
/**
 * This method has been deprecated, please use method buildBasicAuth instead.
 * @return The buildable object.
 */
@Deprecated public BasicAuth getBasicAuth(){
            return this.basicAuth!=null?this.basicAuth.build():null;
    }

    public BasicAuth buildBasicAuth(){
            return this.basicAuth!=null?this.basicAuth.build():null;
    }

    public A withBasicAuth(BasicAuth basicAuth){
            _visitables.get("basicAuth").remove(this.basicAuth);
            if (basicAuth!=null){ this.basicAuth= new BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} return (A) this;
    }

    public Boolean hasBasicAuth(){
            return this.basicAuth != null;
    }

    public EndpointFluent.BasicAuthNested<A> withNewBasicAuth(){
            return new BasicAuthNestedImpl();
    }

    public EndpointFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item){
            return new BasicAuthNestedImpl(item);
    }

    public EndpointFluent.BasicAuthNested<A> editBasicAuth(){
            return withNewBasicAuthLike(getBasicAuth());
    }

    public EndpointFluent.BasicAuthNested<A> editOrNewBasicAuth(){
            return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new BasicAuthBuilder().build());
    }

    public EndpointFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item){
            return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
    }

    public String getBearerTokenFile(){
            return this.bearerTokenFile;
    }

    public A withBearerTokenFile(String bearerTokenFile){
            this.bearerTokenFile=bearerTokenFile; return (A) this;
    }

    public Boolean hasBearerTokenFile(){
            return this.bearerTokenFile != null;
    }

    public A withNewBearerTokenFile(String arg1){
            return (A)withBearerTokenFile(new String(arg1));
    }

    public A withNewBearerTokenFile(StringBuilder arg1){
            return (A)withBearerTokenFile(new String(arg1));
    }

    public A withNewBearerTokenFile(StringBuffer arg1){
            return (A)withBearerTokenFile(new String(arg1));
    }

    public SecretKeySelector getBearerTokenSecret(){
            return this.bearerTokenSecret;
    }

    public A withBearerTokenSecret(SecretKeySelector bearerTokenSecret){
            this.bearerTokenSecret=bearerTokenSecret; return (A) this;
    }

    public Boolean hasBearerTokenSecret(){
            return this.bearerTokenSecret != null;
    }

    public A withNewBearerTokenSecret(String key,String name,Boolean optional){
            return (A)withBearerTokenSecret(new SecretKeySelector(key, name, optional));
    }

    public Boolean isHonorLabels(){
            return this.honorLabels;
    }

    public A withHonorLabels(Boolean honorLabels){
            this.honorLabels=honorLabels; return (A) this;
    }

    public Boolean hasHonorLabels(){
            return this.honorLabels != null;
    }

    public A withNewHonorLabels(String arg1){
            return (A)withHonorLabels(new Boolean(arg1));
    }

    public A withNewHonorLabels(boolean arg1){
            return (A)withHonorLabels(new Boolean(arg1));
    }

    public Boolean isHonorTimestamps(){
            return this.honorTimestamps;
    }

    public A withHonorTimestamps(Boolean honorTimestamps){
            this.honorTimestamps=honorTimestamps; return (A) this;
    }

    public Boolean hasHonorTimestamps(){
            return this.honorTimestamps != null;
    }

    public A withNewHonorTimestamps(String arg1){
            return (A)withHonorTimestamps(new Boolean(arg1));
    }

    public A withNewHonorTimestamps(boolean arg1){
            return (A)withHonorTimestamps(new Boolean(arg1));
    }

    public String getInterval(){
            return this.interval;
    }

    public A withInterval(String interval){
            this.interval=interval; return (A) this;
    }

    public Boolean hasInterval(){
            return this.interval != null;
    }

    public A withNewInterval(String arg1){
            return (A)withInterval(new String(arg1));
    }

    public A withNewInterval(StringBuilder arg1){
            return (A)withInterval(new String(arg1));
    }

    public A withNewInterval(StringBuffer arg1){
            return (A)withInterval(new String(arg1));
    }

    public A addToMetricRelabelings(int index,RelabelConfig item){
            if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(index >= 0 ? index : _visitables.get("metricRelabelings").size(), builder);this.metricRelabelings.add(index >= 0 ? index : metricRelabelings.size(), builder); return (A)this;
    }

    public A setToMetricRelabelings(int index,RelabelConfig item){
            if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            if (index < 0 || index >= _visitables.get("metricRelabelings").size()) { _visitables.get("metricRelabelings").add(builder); } else { _visitables.get("metricRelabelings").set(index, builder);}
            if (index < 0 || index >= metricRelabelings.size()) { metricRelabelings.add(builder); } else { metricRelabelings.set(index, builder);}
             return (A)this;
    }

    public A addToMetricRelabelings(RelabelConfig... items){
            if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
            for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
    }

    public A addAllToMetricRelabelings(Collection<RelabelConfig> items){
            if (this.metricRelabelings == null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();}
            for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
    }

    public A removeFromMetricRelabelings(RelabelConfig... items){
            for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
    }

    public A removeAllFromMetricRelabelings(Collection<RelabelConfig> items){
            for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMetricRelabelings(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate){
            if (metricRelabelings == null) return (A) this;
            final Iterator<RelabelConfigBuilder> each = metricRelabelings.iterator();
            final List visitables = _visitables.get("metricRelabelings");
            while (each.hasNext()) {
              RelabelConfigBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMetricRelabelings instead.
 * @return The buildable object.
 */
@Deprecated public List<RelabelConfig> getMetricRelabelings(){
            return build(metricRelabelings);
    }

    public List<RelabelConfig> buildMetricRelabelings(){
            return build(metricRelabelings);
    }

    public RelabelConfig buildMetricRelabeling(int index){
            return this.metricRelabelings.get(index).build();
    }

    public RelabelConfig buildFirstMetricRelabeling(){
            return this.metricRelabelings.get(0).build();
    }

    public RelabelConfig buildLastMetricRelabeling(){
            return this.metricRelabelings.get(metricRelabelings.size() - 1).build();
    }

    public RelabelConfig buildMatchingMetricRelabeling(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate){
            for (RelabelConfigBuilder item: metricRelabelings) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingMetricRelabeling(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate){
            for (RelabelConfigBuilder item: metricRelabelings) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withMetricRelabelings(List<RelabelConfig> metricRelabelings){
            if (this.metricRelabelings != null) { _visitables.get("metricRelabelings").removeAll(this.metricRelabelings);}
            if (metricRelabelings != null) {this.metricRelabelings = new ArrayList<RelabelConfigBuilder>(); for (RelabelConfig item : metricRelabelings){this.addToMetricRelabelings(item);}} else { this.metricRelabelings = null;} return (A) this;
    }

    public A withMetricRelabelings(RelabelConfig... metricRelabelings){
            if (this.metricRelabelings != null) {this.metricRelabelings.clear();}
            if (metricRelabelings != null) {for (RelabelConfig item :metricRelabelings){ this.addToMetricRelabelings(item);}} return (A) this;
    }

    public Boolean hasMetricRelabelings(){
            return metricRelabelings != null && !metricRelabelings.isEmpty();
    }

    public EndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabeling(){
            return new MetricRelabelingsNestedImpl();
    }

    public EndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabelingLike(RelabelConfig item){
            return new MetricRelabelingsNestedImpl(-1, item);
    }

    public EndpointFluent.MetricRelabelingsNested<A> setNewMetricRelabelingLike(int index,RelabelConfig item){
            return new MetricRelabelingsNestedImpl(index, item);
    }

    public EndpointFluent.MetricRelabelingsNested<A> editMetricRelabeling(int index){
            if (metricRelabelings.size() <= index) throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
            return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
    }

    public EndpointFluent.MetricRelabelingsNested<A> editFirstMetricRelabeling(){
            if (metricRelabelings.size() == 0) throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
            return setNewMetricRelabelingLike(0, buildMetricRelabeling(0));
    }

    public EndpointFluent.MetricRelabelingsNested<A> editLastMetricRelabeling(){
            int index = metricRelabelings.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
            return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
    }

    public EndpointFluent.MetricRelabelingsNested<A> editMatchingMetricRelabeling(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate){
            int index = -1;
            for (int i=0;i<metricRelabelings.size();i++) { 
            if (predicate.apply(metricRelabelings.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
            return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
    }

    public A addToParams(String key,ArrayList<String> value){
            if(this.params == null && key != null && value != null) { this.params = new LinkedHashMap<String,ArrayList<String>>(); }
            if(key != null && value != null) {this.params.put(key, value);} return (A)this;
    }

    public A addToParams(Map<String,ArrayList<String>> map){
            if(this.params == null && map != null) { this.params = new LinkedHashMap<String,ArrayList<String>>(); }
            if(map != null) { this.params.putAll(map);} return (A)this;
    }

    public A removeFromParams(String key){
            if(this.params == null) { return (A) this; }
            if(key != null && this.params != null) {this.params.remove(key);} return (A)this;
    }

    public A removeFromParams(Map<String,ArrayList<String>> map){
            if(this.params == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.params != null){this.params.remove(key);}}} return (A)this;
    }

    public Map<String,ArrayList<String>> getParams(){
            return this.params;
    }

    public A withParams(Map<String,ArrayList<String>> params){
            if (params == null) { this.params =  null;} else {this.params = new LinkedHashMap<String,ArrayList<String>>(params);} return (A) this;
    }

    public Boolean hasParams(){
            return this.params != null;
    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public Boolean hasPath(){
            return this.path != null;
    }

    public A withNewPath(String arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1){
            return (A)withPath(new String(arg1));
    }

    public String getPort(){
            return this.port;
    }

    public A withPort(String port){
            this.port=port; return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A withNewPort(String arg1){
            return (A)withPort(new String(arg1));
    }

    public A withNewPort(StringBuilder arg1){
            return (A)withPort(new String(arg1));
    }

    public A withNewPort(StringBuffer arg1){
            return (A)withPort(new String(arg1));
    }

    public String getProxyUrl(){
            return this.proxyUrl;
    }

    public A withProxyUrl(String proxyUrl){
            this.proxyUrl=proxyUrl; return (A) this;
    }

    public Boolean hasProxyUrl(){
            return this.proxyUrl != null;
    }

    public A withNewProxyUrl(String arg1){
            return (A)withProxyUrl(new String(arg1));
    }

    public A withNewProxyUrl(StringBuilder arg1){
            return (A)withProxyUrl(new String(arg1));
    }

    public A withNewProxyUrl(StringBuffer arg1){
            return (A)withProxyUrl(new String(arg1));
    }

    public A addToRelabelings(int index,RelabelConfig item){
            if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(index >= 0 ? index : _visitables.get("relabelings").size(), builder);this.relabelings.add(index >= 0 ? index : relabelings.size(), builder); return (A)this;
    }

    public A setToRelabelings(int index,RelabelConfig item){
            if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            if (index < 0 || index >= _visitables.get("relabelings").size()) { _visitables.get("relabelings").add(builder); } else { _visitables.get("relabelings").set(index, builder);}
            if (index < 0 || index >= relabelings.size()) { relabelings.add(builder); } else { relabelings.set(index, builder);}
             return (A)this;
    }

    public A addToRelabelings(RelabelConfig... items){
            if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
            for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
    }

    public A addAllToRelabelings(Collection<RelabelConfig> items){
            if (this.relabelings == null) {this.relabelings = new ArrayList<RelabelConfigBuilder>();}
            for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
    }

    public A removeFromRelabelings(RelabelConfig... items){
            for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder);if (this.relabelings != null) {this.relabelings.remove(builder);}} return (A)this;
    }

    public A removeAllFromRelabelings(Collection<RelabelConfig> items){
            for (RelabelConfig item : items) {RelabelConfigBuilder builder = new RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder);if (this.relabelings != null) {this.relabelings.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRelabelings(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate){
            if (relabelings == null) return (A) this;
            final Iterator<RelabelConfigBuilder> each = relabelings.iterator();
            final List visitables = _visitables.get("relabelings");
            while (each.hasNext()) {
              RelabelConfigBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRelabelings instead.
 * @return The buildable object.
 */
@Deprecated public List<RelabelConfig> getRelabelings(){
            return build(relabelings);
    }

    public List<RelabelConfig> buildRelabelings(){
            return build(relabelings);
    }

    public RelabelConfig buildRelabeling(int index){
            return this.relabelings.get(index).build();
    }

    public RelabelConfig buildFirstRelabeling(){
            return this.relabelings.get(0).build();
    }

    public RelabelConfig buildLastRelabeling(){
            return this.relabelings.get(relabelings.size() - 1).build();
    }

    public RelabelConfig buildMatchingRelabeling(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate){
            for (RelabelConfigBuilder item: relabelings) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRelabeling(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate){
            for (RelabelConfigBuilder item: relabelings) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRelabelings(List<RelabelConfig> relabelings){
            if (this.relabelings != null) { _visitables.get("relabelings").removeAll(this.relabelings);}
            if (relabelings != null) {this.relabelings = new ArrayList<RelabelConfigBuilder>(); for (RelabelConfig item : relabelings){this.addToRelabelings(item);}} else { this.relabelings = null;} return (A) this;
    }

    public A withRelabelings(RelabelConfig... relabelings){
            if (this.relabelings != null) {this.relabelings.clear();}
            if (relabelings != null) {for (RelabelConfig item :relabelings){ this.addToRelabelings(item);}} return (A) this;
    }

    public Boolean hasRelabelings(){
            return relabelings != null && !relabelings.isEmpty();
    }

    public EndpointFluent.RelabelingsNested<A> addNewRelabeling(){
            return new RelabelingsNestedImpl();
    }

    public EndpointFluent.RelabelingsNested<A> addNewRelabelingLike(RelabelConfig item){
            return new RelabelingsNestedImpl(-1, item);
    }

    public EndpointFluent.RelabelingsNested<A> setNewRelabelingLike(int index,RelabelConfig item){
            return new RelabelingsNestedImpl(index, item);
    }

    public EndpointFluent.RelabelingsNested<A> editRelabeling(int index){
            if (relabelings.size() <= index) throw new RuntimeException("Can't edit relabelings. Index exceeds size.");
            return setNewRelabelingLike(index, buildRelabeling(index));
    }

    public EndpointFluent.RelabelingsNested<A> editFirstRelabeling(){
            if (relabelings.size() == 0) throw new RuntimeException("Can't edit first relabelings. The list is empty.");
            return setNewRelabelingLike(0, buildRelabeling(0));
    }

    public EndpointFluent.RelabelingsNested<A> editLastRelabeling(){
            int index = relabelings.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last relabelings. The list is empty.");
            return setNewRelabelingLike(index, buildRelabeling(index));
    }

    public EndpointFluent.RelabelingsNested<A> editMatchingRelabeling(io.fabric8.kubernetes.api.builder.Predicate<RelabelConfigBuilder> predicate){
            int index = -1;
            for (int i=0;i<relabelings.size();i++) { 
            if (predicate.apply(relabelings.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching relabelings. No match found.");
            return setNewRelabelingLike(index, buildRelabeling(index));
    }

    public String getScheme(){
            return this.scheme;
    }

    public A withScheme(String scheme){
            this.scheme=scheme; return (A) this;
    }

    public Boolean hasScheme(){
            return this.scheme != null;
    }

    public A withNewScheme(String arg1){
            return (A)withScheme(new String(arg1));
    }

    public A withNewScheme(StringBuilder arg1){
            return (A)withScheme(new String(arg1));
    }

    public A withNewScheme(StringBuffer arg1){
            return (A)withScheme(new String(arg1));
    }

    public String getScrapeTimeout(){
            return this.scrapeTimeout;
    }

    public A withScrapeTimeout(String scrapeTimeout){
            this.scrapeTimeout=scrapeTimeout; return (A) this;
    }

    public Boolean hasScrapeTimeout(){
            return this.scrapeTimeout != null;
    }

    public A withNewScrapeTimeout(String arg1){
            return (A)withScrapeTimeout(new String(arg1));
    }

    public A withNewScrapeTimeout(StringBuilder arg1){
            return (A)withScrapeTimeout(new String(arg1));
    }

    public A withNewScrapeTimeout(StringBuffer arg1){
            return (A)withScrapeTimeout(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTargetPort instead.
 * @return The buildable object.
 */
@Deprecated public IntOrString getTargetPort(){
            return this.targetPort!=null?this.targetPort.build():null;
    }

    public IntOrString buildTargetPort(){
            return this.targetPort!=null?this.targetPort.build():null;
    }

    public A withTargetPort(IntOrString targetPort){
            _visitables.get("targetPort").remove(this.targetPort);
            if (targetPort!=null){ this.targetPort= new IntOrStringBuilder(targetPort); _visitables.get("targetPort").add(this.targetPort);} return (A) this;
    }

    public Boolean hasTargetPort(){
            return this.targetPort != null;
    }

    public A withNewTargetPort(String strVal){
            return (A)withTargetPort(new IntOrString(strVal));
    }

    public A withNewTargetPort(Integer intVal){
            return (A)withTargetPort(new IntOrString(intVal));
    }

    public EndpointFluent.TargetPortNested<A> withNewTargetPort(){
            return new TargetPortNestedImpl();
    }

    public EndpointFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item){
            return new TargetPortNestedImpl(item);
    }

    public EndpointFluent.TargetPortNested<A> editTargetPort(){
            return withNewTargetPortLike(getTargetPort());
    }

    public EndpointFluent.TargetPortNested<A> editOrNewTargetPort(){
            return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): new IntOrStringBuilder().build());
    }

    public EndpointFluent.TargetPortNested<A> editOrNewTargetPortLike(IntOrString item){
            return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsConfig instead.
 * @return The buildable object.
 */
@Deprecated public TLSConfig getTlsConfig(){
            return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public TLSConfig buildTlsConfig(){
            return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public A withTlsConfig(TLSConfig tlsConfig){
            _visitables.get("tlsConfig").remove(this.tlsConfig);
            if (tlsConfig!=null){ this.tlsConfig= new TLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} return (A) this;
    }

    public Boolean hasTlsConfig(){
            return this.tlsConfig != null;
    }

    public EndpointFluent.TlsConfigNested<A> withNewTlsConfig(){
            return new TlsConfigNestedImpl();
    }

    public EndpointFluent.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item){
            return new TlsConfigNestedImpl(item);
    }

    public EndpointFluent.TlsConfigNested<A> editTlsConfig(){
            return withNewTlsConfigLike(getTlsConfig());
    }

    public EndpointFluent.TlsConfigNested<A> editOrNewTlsConfig(){
            return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new TLSConfigBuilder().build());
    }

    public EndpointFluent.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item){
            return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            EndpointFluentImpl that = (EndpointFluentImpl) o;
            if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
            if (bearerTokenFile != null ? !bearerTokenFile.equals(that.bearerTokenFile) :that.bearerTokenFile != null) return false;
            if (bearerTokenSecret != null ? !bearerTokenSecret.equals(that.bearerTokenSecret) :that.bearerTokenSecret != null) return false;
            if (honorLabels != null ? !honorLabels.equals(that.honorLabels) :that.honorLabels != null) return false;
            if (honorTimestamps != null ? !honorTimestamps.equals(that.honorTimestamps) :that.honorTimestamps != null) return false;
            if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
            if (metricRelabelings != null ? !metricRelabelings.equals(that.metricRelabelings) :that.metricRelabelings != null) return false;
            if (params != null ? !params.equals(that.params) :that.params != null) return false;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (proxyUrl != null ? !proxyUrl.equals(that.proxyUrl) :that.proxyUrl != null) return false;
            if (relabelings != null ? !relabelings.equals(that.relabelings) :that.relabelings != null) return false;
            if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
            if (scrapeTimeout != null ? !scrapeTimeout.equals(that.scrapeTimeout) :that.scrapeTimeout != null) return false;
            if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
            if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
            return true;
    }


    public class BasicAuthNestedImpl<N> extends BasicAuthFluentImpl<EndpointFluent.BasicAuthNested<N>> implements EndpointFluent.BasicAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BasicAuthBuilder builder;
    
            BasicAuthNestedImpl(BasicAuth item){
                    this.builder = new BasicAuthBuilder(this, item);
            }
            BasicAuthNestedImpl(){
                    this.builder = new BasicAuthBuilder(this);
            }
    
    public N and(){
            return (N) EndpointFluentImpl.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth(){
            return and();
    }

}
    public class MetricRelabelingsNestedImpl<N> extends RelabelConfigFluentImpl<EndpointFluent.MetricRelabelingsNested<N>> implements EndpointFluent.MetricRelabelingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RelabelConfigBuilder builder;
        private final int index;
    
            MetricRelabelingsNestedImpl(int index,RelabelConfig item){
                    this.index = index;
                    this.builder = new RelabelConfigBuilder(this, item);
            }
            MetricRelabelingsNestedImpl(){
                    this.index = -1;
                    this.builder = new RelabelConfigBuilder(this);
            }
    
    public N and(){
            return (N) EndpointFluentImpl.this.setToMetricRelabelings(index,builder.build());
    }
    public N endMetricRelabeling(){
            return and();
    }

}
    public class RelabelingsNestedImpl<N> extends RelabelConfigFluentImpl<EndpointFluent.RelabelingsNested<N>> implements EndpointFluent.RelabelingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RelabelConfigBuilder builder;
        private final int index;
    
            RelabelingsNestedImpl(int index,RelabelConfig item){
                    this.index = index;
                    this.builder = new RelabelConfigBuilder(this, item);
            }
            RelabelingsNestedImpl(){
                    this.index = -1;
                    this.builder = new RelabelConfigBuilder(this);
            }
    
    public N and(){
            return (N) EndpointFluentImpl.this.setToRelabelings(index,builder.build());
    }
    public N endRelabeling(){
            return and();
    }

}
    public class TargetPortNestedImpl<N> extends IntOrStringFluentImpl<EndpointFluent.TargetPortNested<N>> implements EndpointFluent.TargetPortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IntOrStringBuilder builder;
    
            TargetPortNestedImpl(IntOrString item){
                    this.builder = new IntOrStringBuilder(this, item);
            }
            TargetPortNestedImpl(){
                    this.builder = new IntOrStringBuilder(this);
            }
    
    public N and(){
            return (N) EndpointFluentImpl.this.withTargetPort(builder.build());
    }
    public N endTargetPort(){
            return and();
    }

}
    public class TlsConfigNestedImpl<N> extends TLSConfigFluentImpl<EndpointFluent.TlsConfigNested<N>> implements EndpointFluent.TlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TLSConfigBuilder builder;
    
            TlsConfigNestedImpl(TLSConfig item){
                    this.builder = new TLSConfigBuilder(this, item);
            }
            TlsConfigNestedImpl(){
                    this.builder = new TLSConfigBuilder(this);
            }
    
    public N and(){
            return (N) EndpointFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig(){
            return and();
    }

}


}
