package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.SecretKeySelector;

public interface BasicAuthFluent<A extends BasicAuthFluent<A>> extends Fluent<A>{


    public SecretKeySelector getPassword();
    public A withPassword(SecretKeySelector password);
    public Boolean hasPassword();
    public A withNewPassword(String key,String name,Boolean optional);
    public SecretKeySelector getUsername();
    public A withUsername(SecretKeySelector username);
    public Boolean hasUsername();
    public A withNewUsername(String key,String name,Boolean optional);



}
