package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AlertmanagerEndpointsBuilder extends AlertmanagerEndpointsFluentImpl<AlertmanagerEndpointsBuilder> implements VisitableBuilder<AlertmanagerEndpoints,AlertmanagerEndpointsBuilder>{

    AlertmanagerEndpointsFluent<?> fluent;
    Boolean validationEnabled;

    public AlertmanagerEndpointsBuilder(){
            this(true);
    }
    public AlertmanagerEndpointsBuilder(Boolean validationEnabled){
            this(new AlertmanagerEndpoints(), validationEnabled);
    }
    public AlertmanagerEndpointsBuilder(AlertmanagerEndpointsFluent<?> fluent){
            this(fluent, true);
    }
    public AlertmanagerEndpointsBuilder(AlertmanagerEndpointsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AlertmanagerEndpoints(), validationEnabled);
    }
    public AlertmanagerEndpointsBuilder(AlertmanagerEndpointsFluent<?> fluent,AlertmanagerEndpoints instance){
            this(fluent, instance, true);
    }
    public AlertmanagerEndpointsBuilder(AlertmanagerEndpointsFluent<?> fluent,AlertmanagerEndpoints instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withBearerTokenFile(instance.getBearerTokenFile()); 
            fluent.withName(instance.getName()); 
            fluent.withNamespace(instance.getNamespace()); 
            fluent.withPathPrefix(instance.getPathPrefix()); 
            fluent.withPort(instance.getPort()); 
            fluent.withScheme(instance.getScheme()); 
            fluent.withTlsConfig(instance.getTlsConfig()); 
            this.validationEnabled = validationEnabled; 
    }
    public AlertmanagerEndpointsBuilder(AlertmanagerEndpoints instance){
            this(instance,true);
    }
    public AlertmanagerEndpointsBuilder(AlertmanagerEndpoints instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withBearerTokenFile(instance.getBearerTokenFile()); 
            this.withName(instance.getName()); 
            this.withNamespace(instance.getNamespace()); 
            this.withPathPrefix(instance.getPathPrefix()); 
            this.withPort(instance.getPort()); 
            this.withScheme(instance.getScheme()); 
            this.withTlsConfig(instance.getTlsConfig()); 
            this.validationEnabled = validationEnabled; 
    }

    public AlertmanagerEndpoints build(){
            AlertmanagerEndpoints buildable = new AlertmanagerEndpoints(fluent.getApiVersion(),fluent.getBearerTokenFile(),fluent.getName(),fluent.getNamespace(),fluent.getPathPrefix(),fluent.getPort(),fluent.getScheme(),fluent.getTlsConfig());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AlertmanagerEndpointsBuilder that = (AlertmanagerEndpointsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
