package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AlertingSpecBuilder extends AlertingSpecFluentImpl<AlertingSpecBuilder> implements VisitableBuilder<AlertingSpec,AlertingSpecBuilder>{

    AlertingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public AlertingSpecBuilder(){
            this(true);
    }
    public AlertingSpecBuilder(Boolean validationEnabled){
            this(new AlertingSpec(), validationEnabled);
    }
    public AlertingSpecBuilder(AlertingSpecFluent<?> fluent){
            this(fluent, true);
    }
    public AlertingSpecBuilder(AlertingSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AlertingSpec(), validationEnabled);
    }
    public AlertingSpecBuilder(AlertingSpecFluent<?> fluent,AlertingSpec instance){
            this(fluent, instance, true);
    }
    public AlertingSpecBuilder(AlertingSpecFluent<?> fluent,AlertingSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAlertmanagers(instance.getAlertmanagers()); 
            this.validationEnabled = validationEnabled; 
    }
    public AlertingSpecBuilder(AlertingSpec instance){
            this(instance,true);
    }
    public AlertingSpecBuilder(AlertingSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAlertmanagers(instance.getAlertmanagers()); 
            this.validationEnabled = validationEnabled; 
    }

    public AlertingSpec build(){
            AlertingSpec buildable = new AlertingSpec(fluent.getAlertmanagers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AlertingSpecBuilder that = (AlertingSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
