package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServerConfigBuilder extends APIServerConfigFluentImpl<APIServerConfigBuilder> implements VisitableBuilder<APIServerConfig,APIServerConfigBuilder>{

    APIServerConfigFluent<?> fluent;
    Boolean validationEnabled;

    public APIServerConfigBuilder(){
            this(true);
    }
    public APIServerConfigBuilder(Boolean validationEnabled){
            this(new APIServerConfig(), validationEnabled);
    }
    public APIServerConfigBuilder(APIServerConfigFluent<?> fluent){
            this(fluent, true);
    }
    public APIServerConfigBuilder(APIServerConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new APIServerConfig(), validationEnabled);
    }
    public APIServerConfigBuilder(APIServerConfigFluent<?> fluent,APIServerConfig instance){
            this(fluent, instance, true);
    }
    public APIServerConfigBuilder(APIServerConfigFluent<?> fluent,APIServerConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBasicAuth(instance.getBasicAuth()); 
            fluent.withBearerToken(instance.getBearerToken()); 
            fluent.withBearerTokenFile(instance.getBearerTokenFile()); 
            fluent.withHost(instance.getHost()); 
            fluent.withTlsConfig(instance.getTlsConfig()); 
            this.validationEnabled = validationEnabled; 
    }
    public APIServerConfigBuilder(APIServerConfig instance){
            this(instance,true);
    }
    public APIServerConfigBuilder(APIServerConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBasicAuth(instance.getBasicAuth()); 
            this.withBearerToken(instance.getBearerToken()); 
            this.withBearerTokenFile(instance.getBearerTokenFile()); 
            this.withHost(instance.getHost()); 
            this.withTlsConfig(instance.getTlsConfig()); 
            this.validationEnabled = validationEnabled; 
    }

    public APIServerConfig build(){
            APIServerConfig buildable = new APIServerConfig(fluent.getBasicAuth(),fluent.getBearerToken(),fluent.getBearerTokenFile(),fluent.getHost(),fluent.getTlsConfig());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            APIServerConfigBuilder that = (APIServerConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
