package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConsolePluginSpecFluent<A extends ConsolePluginSpecFluent<A>> extends BaseFluent<A>{
  public ConsolePluginSpecFluent() {
  }
  
  public ConsolePluginSpecFluent(ConsolePluginSpec instance) {
    this.copyInstance(instance);
  }
  private String displayName;
  private ArrayList<ConsolePluginProxyBuilder> proxy = new ArrayList<ConsolePluginProxyBuilder>();
  private ConsolePluginServiceBuilder service;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConsolePluginSpec instance) {
    instance = (instance != null ? instance : new ConsolePluginSpec());
  
    if (instance != null) {
        this.withDisplayName(instance.getDisplayName());
        this.withProxy(instance.getProxy());
        this.withService(instance.getService());
        this.withDisplayName(instance.getDisplayName());
        this.withProxy(instance.getProxy());
        this.withService(instance.getService());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getDisplayName() {
    return this.displayName;
  }
  
  public A withDisplayName(String displayName) {
    this.displayName=displayName; return (A) this;
  }
  
  public boolean hasDisplayName() {
    return this.displayName != null;
  }
  
  public A addToProxy(int index,ConsolePluginProxy item) {
    if (this.proxy == null) {this.proxy = new ArrayList<ConsolePluginProxyBuilder>();}
    ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
    if (index < 0 || index >= proxy.size()) { _visitables.get("proxy").add(builder); proxy.add(builder); } else { _visitables.get("proxy").add(index, builder); proxy.add(index, builder);}
    return (A)this;
  }
  
  public A setToProxy(int index,ConsolePluginProxy item) {
    if (this.proxy == null) {this.proxy = new ArrayList<ConsolePluginProxyBuilder>();}
    ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);
    if (index < 0 || index >= proxy.size()) { _visitables.get("proxy").add(builder); proxy.add(builder); } else { _visitables.get("proxy").set(index, builder); proxy.set(index, builder);}
    return (A)this;
  }
  
  public A addToProxy(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginProxy... items) {
    if (this.proxy == null) {this.proxy = new ArrayList<ConsolePluginProxyBuilder>();}
    for (ConsolePluginProxy item : items) {ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);_visitables.get("proxy").add(builder);this.proxy.add(builder);} return (A)this;
  }
  
  public A addAllToProxy(Collection<ConsolePluginProxy> items) {
    if (this.proxy == null) {this.proxy = new ArrayList<ConsolePluginProxyBuilder>();}
    for (ConsolePluginProxy item : items) {ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);_visitables.get("proxy").add(builder);this.proxy.add(builder);} return (A)this;
  }
  
  public A removeFromProxy(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginProxy... items) {
    if (this.proxy == null) return (A)this;
    for (ConsolePluginProxy item : items) {ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);_visitables.get("proxy").remove(builder); this.proxy.remove(builder);} return (A)this;
  }
  
  public A removeAllFromProxy(Collection<ConsolePluginProxy> items) {
    if (this.proxy == null) return (A)this;
    for (ConsolePluginProxy item : items) {ConsolePluginProxyBuilder builder = new ConsolePluginProxyBuilder(item);_visitables.get("proxy").remove(builder); this.proxy.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromProxy(Predicate<ConsolePluginProxyBuilder> predicate) {
    if (proxy == null) return (A) this;
    final Iterator<ConsolePluginProxyBuilder> each = proxy.iterator();
    final List visitables = _visitables.get("proxy");
    while (each.hasNext()) {
      ConsolePluginProxyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ConsolePluginProxy> buildProxy() {
    return proxy != null ? build(proxy) : null;
  }
  
  public ConsolePluginProxy buildProxy(int index) {
    return this.proxy.get(index).build();
  }
  
  public ConsolePluginProxy buildFirstProxy() {
    return this.proxy.get(0).build();
  }
  
  public ConsolePluginProxy buildLastProxy() {
    return this.proxy.get(proxy.size() - 1).build();
  }
  
  public ConsolePluginProxy buildMatchingProxy(Predicate<ConsolePluginProxyBuilder> predicate) {
    for (ConsolePluginProxyBuilder item: proxy) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingProxy(Predicate<ConsolePluginProxyBuilder> predicate) {
    for (ConsolePluginProxyBuilder item: proxy) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withProxy(List<ConsolePluginProxy> proxy) {
    if (this.proxy != null) { _visitables.get("proxy").clear();}
    if (proxy != null) {this.proxy = new ArrayList(); for (ConsolePluginProxy item : proxy){this.addToProxy(item);}} else { this.proxy = null;} return (A) this;
  }
  
  public A withProxy(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginProxy... proxy) {
    if (this.proxy != null) {this.proxy.clear(); _visitables.remove("proxy"); }
    if (proxy != null) {for (ConsolePluginProxy item :proxy){ this.addToProxy(item);}} return (A) this;
  }
  
  public boolean hasProxy() {
    return proxy != null && !proxy.isEmpty();
  }
  
  public ProxyNested<A> addNewProxy() {
    return new ProxyNested(-1, null);
  }
  
  public ProxyNested<A> addNewProxyLike(ConsolePluginProxy item) {
    return new ProxyNested(-1, item);
  }
  
  public ProxyNested<A> setNewProxyLike(int index,ConsolePluginProxy item) {
    return new ProxyNested(index, item);
  }
  
  public ProxyNested<A> editProxy(int index) {
    if (proxy.size() <= index) throw new RuntimeException("Can't edit proxy. Index exceeds size.");
    return setNewProxyLike(index, buildProxy(index));
  }
  
  public ProxyNested<A> editFirstProxy() {
    if (proxy.size() == 0) throw new RuntimeException("Can't edit first proxy. The list is empty.");
    return setNewProxyLike(0, buildProxy(0));
  }
  
  public ProxyNested<A> editLastProxy() {
    int index = proxy.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last proxy. The list is empty.");
    return setNewProxyLike(index, buildProxy(index));
  }
  
  public ProxyNested<A> editMatchingProxy(Predicate<ConsolePluginProxyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<proxy.size();i++) { 
    if (predicate.test(proxy.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching proxy. No match found.");
    return setNewProxyLike(index, buildProxy(index));
  }
  
  public ConsolePluginService buildService() {
    return this.service!=null ?this.service.build():null;
  }
  
  public A withService(ConsolePluginService service) {
    _visitables.get("service").remove(this.service);
    if (service!=null){ this.service= new ConsolePluginServiceBuilder(service); _visitables.get("service").add(this.service);} else { this.service = null; _visitables.get("service").remove(this.service); } return (A) this;
  }
  
  public boolean hasService() {
    return this.service != null;
  }
  
  public A withNewService(String basePath,String name,String namespace,Integer port) {
    return (A)withService(new ConsolePluginService(basePath, name, namespace, port));
  }
  
  public ServiceNested<A> withNewService() {
    return new ServiceNested(null);
  }
  
  public ServiceNested<A> withNewServiceLike(ConsolePluginService item) {
    return new ServiceNested(item);
  }
  
  public ServiceNested<A> editService() {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(null));
  }
  
  public ServiceNested<A> editOrNewService() {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(new ConsolePluginServiceBuilder().build()));
  }
  
  public ServiceNested<A> editOrNewServiceLike(ConsolePluginService item) {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsolePluginSpecFluent that = (ConsolePluginSpecFluent) o;
    if (!java.util.Objects.equals(displayName, that.displayName)) return false;
  
    if (!java.util.Objects.equals(proxy, that.proxy)) return false;
  
    if (!java.util.Objects.equals(service, that.service)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(displayName,  proxy,  service,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (displayName != null) { sb.append("displayName:"); sb.append(displayName + ","); }
    if (proxy != null && !proxy.isEmpty()) { sb.append("proxy:"); sb.append(proxy + ","); }
    if (service != null) { sb.append("service:"); sb.append(service + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ProxyNested<N> extends ConsolePluginProxyFluent<ProxyNested<N>> implements Nested<N>{
    ProxyNested(int index,ConsolePluginProxy item) {
      this.index = index;
      this.builder = new ConsolePluginProxyBuilder(this, item);
    }
    ConsolePluginProxyBuilder builder;
    int index;
    
    public N and() {
      return (N) ConsolePluginSpecFluent.this.setToProxy(index,builder.build());
    }
    
    public N endProxy() {
      return and();
    }
    
  
  }
  public class ServiceNested<N> extends ConsolePluginServiceFluent<ServiceNested<N>> implements Nested<N>{
    ServiceNested(ConsolePluginService item) {
      this.builder = new ConsolePluginServiceBuilder(this, item);
    }
    ConsolePluginServiceBuilder builder;
    
    public N and() {
      return (N) ConsolePluginSpecFluent.this.withService(builder.build());
    }
    
    public N endService() {
      return and();
    }
    
  
  }

}