package io.fabric8.openshift.api.model.console.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.TypeMeta;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConsoleYAMLSampleSpecFluent<A extends ConsoleYAMLSampleSpecFluent<A>> extends BaseFluent<A>{
  public ConsoleYAMLSampleSpecFluent() {
  }
  
  public ConsoleYAMLSampleSpecFluent(ConsoleYAMLSampleSpec instance) {
    this.copyInstance(instance);
  }
  private String description;
  private Boolean snippet;
  private TypeMeta targetResource;
  private String title;
  private String yaml;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConsoleYAMLSampleSpec instance) {
    instance = (instance != null ? instance : new ConsoleYAMLSampleSpec());
  
    if (instance != null) {
        this.withDescription(instance.getDescription());
        this.withSnippet(instance.getSnippet());
        this.withTargetResource(instance.getTargetResource());
        this.withTitle(instance.getTitle());
        this.withYaml(instance.getYaml());
        this.withDescription(instance.getDescription());
        this.withSnippet(instance.getSnippet());
        this.withTargetResource(instance.getTargetResource());
        this.withTitle(instance.getTitle());
        this.withYaml(instance.getYaml());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  
  public boolean hasDescription() {
    return this.description != null;
  }
  
  public Boolean getSnippet() {
    return this.snippet;
  }
  
  public A withSnippet(Boolean snippet) {
    this.snippet=snippet; return (A) this;
  }
  
  public boolean hasSnippet() {
    return this.snippet != null;
  }
  
  public TypeMeta getTargetResource() {
    return this.targetResource;
  }
  
  public A withTargetResource(TypeMeta targetResource) {
    this.targetResource=targetResource; return (A) this;
  }
  
  public boolean hasTargetResource() {
    return this.targetResource != null;
  }
  
  public A withNewTargetResource(String apiVersion,String kind) {
    return (A)withTargetResource(new TypeMeta(apiVersion, kind));
  }
  
  public String getTitle() {
    return this.title;
  }
  
  public A withTitle(String title) {
    this.title=title; return (A) this;
  }
  
  public boolean hasTitle() {
    return this.title != null;
  }
  
  public String getYaml() {
    return this.yaml;
  }
  
  public A withYaml(String yaml) {
    this.yaml=yaml; return (A) this;
  }
  
  public boolean hasYaml() {
    return this.yaml != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsoleYAMLSampleSpecFluent that = (ConsoleYAMLSampleSpecFluent) o;
    if (!java.util.Objects.equals(description, that.description)) return false;
  
    if (!java.util.Objects.equals(snippet, that.snippet)) return false;
  
    if (!java.util.Objects.equals(targetResource, that.targetResource)) return false;
  
    if (!java.util.Objects.equals(title, that.title)) return false;
  
    if (!java.util.Objects.equals(yaml, that.yaml)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(description,  snippet,  targetResource,  title,  yaml,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (snippet != null) { sb.append("snippet:"); sb.append(snippet + ","); }
    if (targetResource != null) { sb.append("targetResource:"); sb.append(targetResource + ","); }
    if (title != null) { sb.append("title:"); sb.append(title + ","); }
    if (yaml != null) { sb.append("yaml:"); sb.append(yaml + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSnippet() {
    return withSnippet(true);
  }
  

}