package io.fabric8.openshift.api.model.console.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConsolePluginSpecFluentImpl<A extends ConsolePluginSpecFluent<A>> extends BaseFluent<A> implements ConsolePluginSpecFluent<A>{
  public ConsolePluginSpecFluentImpl() {
  }
  public ConsolePluginSpecFluentImpl(ConsolePluginSpec instance) {
    if (instance != null) {
      this.withDisplayName(instance.getDisplayName());
      this.withProxy(instance.getProxy());
      this.withService(instance.getService());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String displayName;
  private ConsolePluginProxyBuilder proxy;
  private ConsolePluginServiceBuilder service;
  private Map<String,Object> additionalProperties;
  public String getDisplayName() {
    return this.displayName;
  }
  public A withDisplayName(String displayName) {
    this.displayName=displayName; return (A) this;
  }
  public Boolean hasDisplayName() {
    return this.displayName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildProxy instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConsolePluginProxy getProxy() {
    return this.proxy!=null ?this.proxy.build():null;
  }
  public ConsolePluginProxy buildProxy() {
    return this.proxy!=null ?this.proxy.build():null;
  }
  public A withProxy(ConsolePluginProxy proxy) {
    _visitables.get("proxy").remove(this.proxy);
    if (proxy!=null){ this.proxy= new ConsolePluginProxyBuilder(proxy); _visitables.get("proxy").add(this.proxy);} else { this.proxy = null; _visitables.get("proxy").remove(this.proxy); } return (A) this;
  }
  public Boolean hasProxy() {
    return this.proxy != null;
  }
  public ConsolePluginSpecFluentImpl.ProxyNested<A> withNewProxy() {
    return new ConsolePluginSpecFluentImpl.ProxyNestedImpl();
  }
  public ConsolePluginSpecFluentImpl.ProxyNested<A> withNewProxyLike(ConsolePluginProxy item) {
    return new ConsolePluginSpecFluentImpl.ProxyNestedImpl(item);
  }
  public ConsolePluginSpecFluentImpl.ProxyNested<A> editProxy() {
    return withNewProxyLike(getProxy());
  }
  public ConsolePluginSpecFluentImpl.ProxyNested<A> editOrNewProxy() {
    return withNewProxyLike(getProxy() != null ? getProxy(): new ConsolePluginProxyBuilder().build());
  }
  public ConsolePluginSpecFluentImpl.ProxyNested<A> editOrNewProxyLike(ConsolePluginProxy item) {
    return withNewProxyLike(getProxy() != null ? getProxy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildService instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConsolePluginService getService() {
    return this.service!=null ?this.service.build():null;
  }
  public ConsolePluginService buildService() {
    return this.service!=null ?this.service.build():null;
  }
  public A withService(ConsolePluginService service) {
    _visitables.get("service").remove(this.service);
    if (service!=null){ this.service= new ConsolePluginServiceBuilder(service); _visitables.get("service").add(this.service);} else { this.service = null; _visitables.get("service").remove(this.service); } return (A) this;
  }
  public Boolean hasService() {
    return this.service != null;
  }
  public A withNewService(String basePath,String name,String namespace,Integer port) {
    return (A)withService(new ConsolePluginService(basePath, name, namespace, port));
  }
  public ConsolePluginSpecFluentImpl.ServiceNested<A> withNewService() {
    return new ConsolePluginSpecFluentImpl.ServiceNestedImpl();
  }
  public ConsolePluginSpecFluentImpl.ServiceNested<A> withNewServiceLike(ConsolePluginService item) {
    return new ConsolePluginSpecFluentImpl.ServiceNestedImpl(item);
  }
  public ConsolePluginSpecFluentImpl.ServiceNested<A> editService() {
    return withNewServiceLike(getService());
  }
  public ConsolePluginSpecFluentImpl.ServiceNested<A> editOrNewService() {
    return withNewServiceLike(getService() != null ? getService(): new ConsolePluginServiceBuilder().build());
  }
  public ConsolePluginSpecFluentImpl.ServiceNested<A> editOrNewServiceLike(ConsolePluginService item) {
    return withNewServiceLike(getService() != null ? getService(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsolePluginSpecFluentImpl that = (ConsolePluginSpecFluentImpl) o;
    if (!java.util.Objects.equals(displayName, that.displayName)) return false;

    if (!java.util.Objects.equals(proxy, that.proxy)) return false;

    if (!java.util.Objects.equals(service, that.service)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(displayName,  proxy,  service,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (displayName != null) { sb.append("displayName:"); sb.append(displayName + ","); }
    if (proxy != null) { sb.append("proxy:"); sb.append(proxy + ","); }
    if (service != null) { sb.append("service:"); sb.append(service + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ProxyNestedImpl<N> extends ConsolePluginProxyFluentImpl<ConsolePluginSpecFluentImpl.ProxyNested<N>> implements ConsolePluginSpecFluentImpl.ProxyNested<N>,Nested<N>{
    ProxyNestedImpl(ConsolePluginProxy item) {
      this.builder = new ConsolePluginProxyBuilder(this, item);
    }
    ProxyNestedImpl() {
      this.builder = new ConsolePluginProxyBuilder(this);
    }
    ConsolePluginProxyBuilder builder;
    public N and() {
      return (N) ConsolePluginSpecFluentImpl.this.withProxy(builder.build());
    }
    public N endProxy() {
      return and();
    }
    
  }
  class ServiceNestedImpl<N> extends ConsolePluginServiceFluentImpl<ConsolePluginSpecFluentImpl.ServiceNested<N>> implements ConsolePluginSpecFluentImpl.ServiceNested<N>,Nested<N>{
    ServiceNestedImpl(ConsolePluginService item) {
      this.builder = new ConsolePluginServiceBuilder(this, item);
    }
    ServiceNestedImpl() {
      this.builder = new ConsolePluginServiceBuilder(this);
    }
    ConsolePluginServiceBuilder builder;
    public N and() {
      return (N) ConsolePluginSpecFluentImpl.this.withService(builder.build());
    }
    public N endService() {
      return and();
    }
    
  }
  
}