package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsolePluginListBuilder extends ConsolePluginListFluentImpl<ConsolePluginListBuilder> implements VisitableBuilder<ConsolePluginList,ConsolePluginListBuilder>{
  public ConsolePluginListBuilder() {
    this(false);
  }
  public ConsolePluginListBuilder(Boolean validationEnabled) {
    this(new ConsolePluginList(), validationEnabled);
  }
  public ConsolePluginListBuilder(ConsolePluginListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsolePluginListBuilder(ConsolePluginListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsolePluginList(), validationEnabled);
  }
  public ConsolePluginListBuilder(ConsolePluginListFluent<?> fluent,ConsolePluginList instance) {
    this(fluent, instance, false);
  }
  public ConsolePluginListBuilder(ConsolePluginListFluent<?> fluent,ConsolePluginList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsolePluginListBuilder(ConsolePluginList instance) {
    this(instance,false);
  }
  public ConsolePluginListBuilder(ConsolePluginList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsolePluginListFluent<?> fluent;
  Boolean validationEnabled;
  public ConsolePluginList build() {
    ConsolePluginList buildable = new ConsolePluginList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}