package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleYAMLSampleListBuilder extends ConsoleYAMLSampleListFluentImpl<ConsoleYAMLSampleListBuilder> implements VisitableBuilder<ConsoleYAMLSampleList,ConsoleYAMLSampleListBuilder>{
  public ConsoleYAMLSampleListBuilder() {
    this(false);
  }
  public ConsoleYAMLSampleListBuilder(Boolean validationEnabled) {
    this(new ConsoleYAMLSampleList(), validationEnabled);
  }
  public ConsoleYAMLSampleListBuilder(ConsoleYAMLSampleListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleYAMLSampleListBuilder(ConsoleYAMLSampleListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleYAMLSampleList(), validationEnabled);
  }
  public ConsoleYAMLSampleListBuilder(ConsoleYAMLSampleListFluent<?> fluent,ConsoleYAMLSampleList instance) {
    this(fluent, instance, false);
  }
  public ConsoleYAMLSampleListBuilder(ConsoleYAMLSampleListFluent<?> fluent,ConsoleYAMLSampleList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleYAMLSampleListBuilder(ConsoleYAMLSampleList instance) {
    this(instance,false);
  }
  public ConsoleYAMLSampleListBuilder(ConsoleYAMLSampleList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleYAMLSampleListFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleYAMLSampleList build() {
    ConsoleYAMLSampleList buildable = new ConsoleYAMLSampleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}