package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleExternalLogLinkBuilder extends ConsoleExternalLogLinkFluentImpl<ConsoleExternalLogLinkBuilder> implements VisitableBuilder<ConsoleExternalLogLink,ConsoleExternalLogLinkBuilder>{
  public ConsoleExternalLogLinkBuilder() {
    this(false);
  }
  public ConsoleExternalLogLinkBuilder(Boolean validationEnabled) {
    this(new ConsoleExternalLogLink(), validationEnabled);
  }
  public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLinkFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLinkFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleExternalLogLink(), validationEnabled);
  }
  public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLinkFluent<?> fluent,ConsoleExternalLogLink instance) {
    this(fluent, instance, false);
  }
  public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLinkFluent<?> fluent,ConsoleExternalLogLink instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLink instance) {
    this(instance,false);
  }
  public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLink instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleExternalLogLinkFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleExternalLogLink build() {
    ConsoleExternalLogLink buildable = new ConsoleExternalLogLink(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}