package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsolePluginProxyBuilder extends ConsolePluginProxyFluentImpl<ConsolePluginProxyBuilder> implements VisitableBuilder<ConsolePluginProxy,ConsolePluginProxyBuilder>{
  public ConsolePluginProxyBuilder() {
    this(false);
  }
  public ConsolePluginProxyBuilder(Boolean validationEnabled) {
    this(new ConsolePluginProxy(), validationEnabled);
  }
  public ConsolePluginProxyBuilder(ConsolePluginProxyFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsolePluginProxyBuilder(ConsolePluginProxyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsolePluginProxy(), validationEnabled);
  }
  public ConsolePluginProxyBuilder(ConsolePluginProxyFluent<?> fluent,ConsolePluginProxy instance) {
    this(fluent, instance, false);
  }
  public ConsolePluginProxyBuilder(ConsolePluginProxyFluent<?> fluent,ConsolePluginProxy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withServices(instance.getServices());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsolePluginProxyBuilder(ConsolePluginProxy instance) {
    this(instance,false);
  }
  public ConsolePluginProxyBuilder(ConsolePluginProxy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withServices(instance.getServices());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsolePluginProxyFluent<?> fluent;
  Boolean validationEnabled;
  public ConsolePluginProxy build() {
    ConsolePluginProxy buildable = new ConsolePluginProxy(fluent.getServices());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}