package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsolePluginSpecBuilder extends ConsolePluginSpecFluentImpl<ConsolePluginSpecBuilder> implements VisitableBuilder<ConsolePluginSpec,io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginSpecBuilder>{
  public ConsolePluginSpecBuilder() {
    this(false);
  }
  public ConsolePluginSpecBuilder(Boolean validationEnabled) {
    this(new ConsolePluginSpec(), validationEnabled);
  }
  public ConsolePluginSpecBuilder(ConsolePluginSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsolePluginSpecBuilder(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsolePluginSpec(), validationEnabled);
  }
  public ConsolePluginSpecBuilder(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginSpecFluent<?> fluent,io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginSpec instance) {
    this(fluent, instance, false);
  }
  public ConsolePluginSpecBuilder(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginSpecFluent<?> fluent,io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDisplayName(instance.getDisplayName()); 
    fluent.withProxy(instance.getProxy()); 
    fluent.withService(instance.getService()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsolePluginSpecBuilder(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginSpec instance) {
    this(instance,false);
  }
  public ConsolePluginSpecBuilder(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDisplayName(instance.getDisplayName()); 
    this.withProxy(instance.getProxy()); 
    this.withService(instance.getService()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginSpec build() {
    ConsolePluginSpec buildable = new ConsolePluginSpec(fluent.getDisplayName(),fluent.getProxy(),fluent.getService());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}