package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsolePluginBuilder extends ConsolePluginFluentImpl<ConsolePluginBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.console.v1alpha1.ConsolePlugin,ConsolePluginBuilder>{
  public ConsolePluginBuilder() {
    this(false);
  }
  public ConsolePluginBuilder(Boolean validationEnabled) {
    this(new ConsolePlugin(), validationEnabled);
  }
  public ConsolePluginBuilder(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsolePluginBuilder(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsolePlugin(), validationEnabled);
  }
  public ConsolePluginBuilder(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginFluent<?> fluent,io.fabric8.openshift.api.model.console.v1alpha1.ConsolePlugin instance) {
    this(fluent, instance, false);
  }
  public ConsolePluginBuilder(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginFluent<?> fluent,io.fabric8.openshift.api.model.console.v1alpha1.ConsolePlugin instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsolePluginBuilder(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePlugin instance) {
    this(instance,false);
  }
  public ConsolePluginBuilder(io.fabric8.openshift.api.model.console.v1alpha1.ConsolePlugin instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.console.v1alpha1.ConsolePluginFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.console.v1alpha1.ConsolePlugin build() {
    ConsolePlugin buildable = new ConsolePlugin(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}