package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LinkBuilder extends LinkFluentImpl<LinkBuilder> implements VisitableBuilder<Link,io.fabric8.openshift.api.model.console.v1.LinkBuilder>{
  public LinkBuilder() {
    this(false);
  }
  public LinkBuilder(Boolean validationEnabled) {
    this(new Link(), validationEnabled);
  }
  public LinkBuilder(io.fabric8.openshift.api.model.console.v1.LinkFluent<?> fluent) {
    this(fluent, false);
  }
  public LinkBuilder(io.fabric8.openshift.api.model.console.v1.LinkFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Link(), validationEnabled);
  }
  public LinkBuilder(io.fabric8.openshift.api.model.console.v1.LinkFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.Link instance) {
    this(fluent, instance, false);
  }
  public LinkBuilder(io.fabric8.openshift.api.model.console.v1.LinkFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.Link instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHref(instance.getHref()); 
    fluent.withText(instance.getText()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LinkBuilder(io.fabric8.openshift.api.model.console.v1.Link instance) {
    this(instance,false);
  }
  public LinkBuilder(io.fabric8.openshift.api.model.console.v1.Link instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHref(instance.getHref()); 
    this.withText(instance.getText()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.console.v1.LinkFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.console.v1.Link build() {
    Link buildable = new Link(fluent.getHref(),fluent.getText());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}