package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleYAMLSampleSpecBuilder extends ConsoleYAMLSampleSpecFluentImpl<ConsoleYAMLSampleSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleSpec,io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleSpecBuilder>{
  public ConsoleYAMLSampleSpecBuilder() {
    this(false);
  }
  public ConsoleYAMLSampleSpecBuilder(Boolean validationEnabled) {
    this(new ConsoleYAMLSampleSpec(), validationEnabled);
  }
  public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleYAMLSampleSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleYAMLSampleSpec(), validationEnabled);
  }
  public ConsoleYAMLSampleSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleSpecFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleSpec instance) {
    this(fluent, instance, false);
  }
  public ConsoleYAMLSampleSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleSpecFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDescription(instance.getDescription()); 
    fluent.withSnippet(instance.getSnippet()); 
    fluent.withTargetResource(instance.getTargetResource()); 
    fluent.withTitle(instance.getTitle()); 
    fluent.withYaml(instance.getYaml()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleYAMLSampleSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleSpec instance) {
    this(instance,false);
  }
  public ConsoleYAMLSampleSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDescription(instance.getDescription()); 
    this.withSnippet(instance.getSnippet()); 
    this.withTargetResource(instance.getTargetResource()); 
    this.withTitle(instance.getTitle()); 
    this.withYaml(instance.getYaml()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.console.v1.ConsoleYAMLSampleSpec build() {
    ConsoleYAMLSampleSpec buildable = new ConsoleYAMLSampleSpec(fluent.getDescription(),fluent.getSnippet(),fluent.getTargetResource(),fluent.getTitle(),fluent.getYaml());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}