package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleQuickStartTaskBuilder extends ConsoleQuickStartTaskFluentImpl<ConsoleQuickStartTaskBuilder> implements VisitableBuilder<ConsoleQuickStartTask,io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskBuilder>{
  public ConsoleQuickStartTaskBuilder() {
    this(false);
  }
  public ConsoleQuickStartTaskBuilder(Boolean validationEnabled) {
    this(new ConsoleQuickStartTask(), validationEnabled);
  }
  public ConsoleQuickStartTaskBuilder(ConsoleQuickStartTaskFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleQuickStartTaskBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleQuickStartTask(), validationEnabled);
  }
  public ConsoleQuickStartTaskBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTask instance) {
    this(fluent, instance, false);
  }
  public ConsoleQuickStartTaskBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTask instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDescription(instance.getDescription()); 
    fluent.withReview(instance.getReview()); 
    fluent.withSummary(instance.getSummary()); 
    fluent.withTitle(instance.getTitle()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleQuickStartTaskBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTask instance) {
    this(instance,false);
  }
  public ConsoleQuickStartTaskBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTask instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDescription(instance.getDescription()); 
    this.withReview(instance.getReview()); 
    this.withSummary(instance.getSummary()); 
    this.withTitle(instance.getTitle()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTask build() {
    ConsoleQuickStartTask buildable = new ConsoleQuickStartTask(fluent.getDescription(),fluent.getReview(),fluent.getSummary(),fluent.getTitle());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}