package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleNotificationListBuilder extends ConsoleNotificationListFluentImpl<ConsoleNotificationListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.console.v1.ConsoleNotificationList,io.fabric8.openshift.api.model.console.v1.ConsoleNotificationListBuilder>{
  public ConsoleNotificationListBuilder() {
    this(false);
  }
  public ConsoleNotificationListBuilder(Boolean validationEnabled) {
    this(new ConsoleNotificationList(), validationEnabled);
  }
  public ConsoleNotificationListBuilder(ConsoleNotificationListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleNotificationListBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleNotificationList(), validationEnabled);
  }
  public ConsoleNotificationListBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationListFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleNotificationList instance) {
    this(fluent, instance, false);
  }
  public ConsoleNotificationListBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationListFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleNotificationList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleNotificationListBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationList instance) {
    this(instance,false);
  }
  public ConsoleNotificationListBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.console.v1.ConsoleNotificationListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.console.v1.ConsoleNotificationList build() {
    ConsoleNotificationList buildable = new ConsoleNotificationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}