package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleNotificationBuilder extends ConsoleNotificationFluentImpl<ConsoleNotificationBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.console.v1.ConsoleNotification,io.fabric8.openshift.api.model.console.v1.ConsoleNotificationBuilder>{
  public ConsoleNotificationBuilder() {
    this(false);
  }
  public ConsoleNotificationBuilder(Boolean validationEnabled) {
    this(new ConsoleNotification(), validationEnabled);
  }
  public ConsoleNotificationBuilder(ConsoleNotificationFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleNotificationBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleNotification(), validationEnabled);
  }
  public ConsoleNotificationBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleNotification instance) {
    this(fluent, instance, false);
  }
  public ConsoleNotificationBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleNotification instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleNotificationBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotification instance) {
    this(instance,false);
  }
  public ConsoleNotificationBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotification instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.console.v1.ConsoleNotificationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.console.v1.ConsoleNotification build() {
    ConsoleNotification buildable = new ConsoleNotification(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}