package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleLinkListBuilder extends ConsoleLinkListFluentImpl<ConsoleLinkListBuilder> implements VisitableBuilder<ConsoleLinkList,io.fabric8.openshift.api.model.console.v1.ConsoleLinkListBuilder>{
  public ConsoleLinkListBuilder() {
    this(false);
  }
  public ConsoleLinkListBuilder(Boolean validationEnabled) {
    this(new ConsoleLinkList(), validationEnabled);
  }
  public ConsoleLinkListBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleLinkListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleLinkListBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleLinkListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleLinkList(), validationEnabled);
  }
  public ConsoleLinkListBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleLinkListFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleLinkList instance) {
    this(fluent, instance, false);
  }
  public ConsoleLinkListBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleLinkListFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleLinkList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleLinkListBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleLinkList instance) {
    this(instance,false);
  }
  public ConsoleLinkListBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleLinkList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.console.v1.ConsoleLinkListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.console.v1.ConsoleLinkList build() {
    ConsoleLinkList buildable = new ConsoleLinkList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}