package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleExternalLogLinkSpecBuilder extends ConsoleExternalLogLinkSpecFluentImpl<ConsoleExternalLogLinkSpecBuilder> implements VisitableBuilder<ConsoleExternalLogLinkSpec,io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkSpecBuilder>{
  public ConsoleExternalLogLinkSpecBuilder() {
    this(false);
  }
  public ConsoleExternalLogLinkSpecBuilder(Boolean validationEnabled) {
    this(new ConsoleExternalLogLinkSpec(), validationEnabled);
  }
  public ConsoleExternalLogLinkSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleExternalLogLinkSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleExternalLogLinkSpec(), validationEnabled);
  }
  public ConsoleExternalLogLinkSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkSpecFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkSpec instance) {
    this(fluent, instance, false);
  }
  public ConsoleExternalLogLinkSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkSpecFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHrefTemplate(instance.getHrefTemplate()); 
    fluent.withNamespaceFilter(instance.getNamespaceFilter()); 
    fluent.withText(instance.getText()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleExternalLogLinkSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkSpec instance) {
    this(instance,false);
  }
  public ConsoleExternalLogLinkSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHrefTemplate(instance.getHrefTemplate()); 
    this.withNamespaceFilter(instance.getNamespaceFilter()); 
    this.withText(instance.getText()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkSpec build() {
    ConsoleExternalLogLinkSpec buildable = new ConsoleExternalLogLinkSpec(fluent.getHrefTemplate(),fluent.getNamespaceFilter(),fluent.getText());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}