package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleExternalLogLinkBuilder extends ConsoleExternalLogLinkFluentImpl<ConsoleExternalLogLinkBuilder> implements VisitableBuilder<ConsoleExternalLogLink,io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkBuilder>{
  public ConsoleExternalLogLinkBuilder() {
    this(false);
  }
  public ConsoleExternalLogLinkBuilder(Boolean validationEnabled) {
    this(new ConsoleExternalLogLink(), validationEnabled);
  }
  public ConsoleExternalLogLinkBuilder(ConsoleExternalLogLinkFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleExternalLogLinkBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleExternalLogLink(), validationEnabled);
  }
  public ConsoleExternalLogLinkBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLink instance) {
    this(fluent, instance, false);
  }
  public ConsoleExternalLogLinkBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLink instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleExternalLogLinkBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLink instance) {
    this(instance,false);
  }
  public ConsoleExternalLogLinkBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLink instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLink build() {
    ConsoleExternalLogLink buildable = new ConsoleExternalLogLink(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}