package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleCLIDownloadSpecBuilder extends ConsoleCLIDownloadSpecFluentImpl<ConsoleCLIDownloadSpecBuilder> implements VisitableBuilder<ConsoleCLIDownloadSpec,io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpecBuilder>{
  public ConsoleCLIDownloadSpecBuilder() {
    this(false);
  }
  public ConsoleCLIDownloadSpecBuilder(Boolean validationEnabled) {
    this(new ConsoleCLIDownloadSpec(), validationEnabled);
  }
  public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleCLIDownloadSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleCLIDownloadSpec(), validationEnabled);
  }
  public ConsoleCLIDownloadSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpecFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpec instance) {
    this(fluent, instance, false);
  }
  public ConsoleCLIDownloadSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpecFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDescription(instance.getDescription()); 
    fluent.withDisplayName(instance.getDisplayName()); 
    fluent.withLinks(instance.getLinks()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleCLIDownloadSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpec instance) {
    this(instance,false);
  }
  public ConsoleCLIDownloadSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDescription(instance.getDescription()); 
    this.withDisplayName(instance.getDisplayName()); 
    this.withLinks(instance.getLinks()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpec build() {
    ConsoleCLIDownloadSpec buildable = new ConsoleCLIDownloadSpec(fluent.getDescription(),fluent.getDisplayName(),fluent.getLinks());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}