package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleLinkBuilder extends io.fabric8.openshift.api.model.console.v1.ConsoleLinkFluentImpl<io.fabric8.openshift.api.model.console.v1.ConsoleLinkBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.console.v1.ConsoleLink,io.fabric8.openshift.api.model.console.v1.ConsoleLinkBuilder> {

    io.fabric8.openshift.api.model.console.v1.ConsoleLinkFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ConsoleLinkBuilder() {
        this(true);
    }

    public ConsoleLinkBuilder(java.lang.Boolean validationEnabled) {
        this(new ConsoleLink(), validationEnabled);
    }

    public ConsoleLinkBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleLinkFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleLinkBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleLinkFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ConsoleLink(), validationEnabled);
    }

    public ConsoleLinkBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleLinkFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleLink instance) {
        this(fluent, instance, true);
    }

    public ConsoleLinkBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleLinkFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleLink instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleLinkBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleLink instance) {
        this(instance,true);
    }

    public ConsoleLinkBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleLink instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.console.v1.ConsoleLink build() {
        ConsoleLink buildable = new ConsoleLink(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleLinkBuilder that = (ConsoleLinkBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
