package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleNotificationBuilder extends io.fabric8.openshift.api.model.console.v1.ConsoleNotificationFluentImpl<io.fabric8.openshift.api.model.console.v1.ConsoleNotificationBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.console.v1.ConsoleNotification,io.fabric8.openshift.api.model.console.v1.ConsoleNotificationBuilder> {

    io.fabric8.openshift.api.model.console.v1.ConsoleNotificationFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ConsoleNotificationBuilder() {
        this(true);
    }

    public ConsoleNotificationBuilder(java.lang.Boolean validationEnabled) {
        this(new ConsoleNotification(), validationEnabled);
    }

    public ConsoleNotificationBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleNotificationBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ConsoleNotification(), validationEnabled);
    }

    public ConsoleNotificationBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleNotification instance) {
        this(fluent, instance, true);
    }

    public ConsoleNotificationBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleNotification instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleNotificationBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotification instance) {
        this(instance,true);
    }

    public ConsoleNotificationBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotification instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.console.v1.ConsoleNotification build() {
        ConsoleNotification buildable = new ConsoleNotification(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleNotificationBuilder that = (ConsoleNotificationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
