package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleYAMLSampleBuilder extends ConsoleYAMLSampleFluentImpl<ConsoleYAMLSampleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ConsoleYAMLSample,ConsoleYAMLSampleBuilder> {

    ConsoleYAMLSampleFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleYAMLSampleBuilder() {
        this(true);
    }

    public ConsoleYAMLSampleBuilder(Boolean validationEnabled) {
        this(new ConsoleYAMLSample(), validationEnabled);
    }

    public ConsoleYAMLSampleBuilder(ConsoleYAMLSampleFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleYAMLSampleBuilder(ConsoleYAMLSampleFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ConsoleYAMLSample(), validationEnabled);
    }

    public ConsoleYAMLSampleBuilder(ConsoleYAMLSampleFluent<?> fluent,ConsoleYAMLSample instance) {
        this(fluent, instance, true);
    }

    public ConsoleYAMLSampleBuilder(ConsoleYAMLSampleFluent<?> fluent,ConsoleYAMLSample instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleYAMLSampleBuilder(ConsoleYAMLSample instance) {
        this(instance,true);
    }

    public ConsoleYAMLSampleBuilder(ConsoleYAMLSample instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleYAMLSample build() {
        ConsoleYAMLSample buildable = new ConsoleYAMLSample(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleYAMLSampleBuilder that = (ConsoleYAMLSampleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
