package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleNotificationSpecBuilder extends ConsoleNotificationSpecFluentImpl<ConsoleNotificationSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ConsoleNotificationSpec,ConsoleNotificationSpecBuilder> {

    ConsoleNotificationSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleNotificationSpecBuilder() {
        this(true);
    }

    public ConsoleNotificationSpecBuilder(Boolean validationEnabled) {
        this(new ConsoleNotificationSpec(), validationEnabled);
    }

    public ConsoleNotificationSpecBuilder(ConsoleNotificationSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleNotificationSpecBuilder(ConsoleNotificationSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ConsoleNotificationSpec(), validationEnabled);
    }

    public ConsoleNotificationSpecBuilder(ConsoleNotificationSpecFluent<?> fluent,ConsoleNotificationSpec instance) {
        this(fluent, instance, true);
    }

    public ConsoleNotificationSpecBuilder(ConsoleNotificationSpecFluent<?> fluent,ConsoleNotificationSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBackgroundColor(instance.getBackgroundColor()); 
        fluent.withColor(instance.getColor()); 
        fluent.withLink(instance.getLink()); 
        fluent.withLocation(instance.getLocation()); 
        fluent.withText(instance.getText()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleNotificationSpecBuilder(ConsoleNotificationSpec instance) {
        this(instance,true);
    }

    public ConsoleNotificationSpecBuilder(ConsoleNotificationSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBackgroundColor(instance.getBackgroundColor()); 
        this.withColor(instance.getColor()); 
        this.withLink(instance.getLink()); 
        this.withLocation(instance.getLocation()); 
        this.withText(instance.getText()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleNotificationSpec build() {
        ConsoleNotificationSpec buildable = new ConsoleNotificationSpec(fluent.getBackgroundColor(),fluent.getColor(),fluent.getLink(),fluent.getLocation(),fluent.getText());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleNotificationSpecBuilder that = (ConsoleNotificationSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
