package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleNotificationListBuilder extends ConsoleNotificationListFluentImpl<ConsoleNotificationListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ConsoleNotificationList,ConsoleNotificationListBuilder> {

    ConsoleNotificationListFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleNotificationListBuilder() {
        this(true);
    }

    public ConsoleNotificationListBuilder(Boolean validationEnabled) {
        this(new ConsoleNotificationList(), validationEnabled);
    }

    public ConsoleNotificationListBuilder(ConsoleNotificationListFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleNotificationListBuilder(ConsoleNotificationListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ConsoleNotificationList(), validationEnabled);
    }

    public ConsoleNotificationListBuilder(ConsoleNotificationListFluent<?> fluent,ConsoleNotificationList instance) {
        this(fluent, instance, true);
    }

    public ConsoleNotificationListBuilder(ConsoleNotificationListFluent<?> fluent,ConsoleNotificationList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleNotificationListBuilder(ConsoleNotificationList instance) {
        this(instance,true);
    }

    public ConsoleNotificationListBuilder(ConsoleNotificationList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleNotificationList build() {
        ConsoleNotificationList buildable = new ConsoleNotificationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleNotificationListBuilder that = (ConsoleNotificationListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
