package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NamespaceDashboardSpecFluentImpl<A extends NamespaceDashboardSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NamespaceDashboardSpecFluent<A> {

    private LabelSelectorBuilder namespaceSelector;
    private List<String> namespaces = new ArrayList<String>();

    public NamespaceDashboardSpecFluentImpl() {
    }

    public NamespaceDashboardSpecFluentImpl(NamespaceDashboardSpec instance) {
        this.withNamespaceSelector(instance.getNamespaceSelector()); 
        this.withNamespaces(instance.getNamespaces()); 
    }

    
/**
 * This method has been deprecated, please use method buildNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        _visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} return (A) this;
    }

    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public io.fabric8.openshift.api.model.console.v1.NamespaceDashboardSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    public io.fabric8.openshift.api.model.console.v1.NamespaceDashboardSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.console.v1.NamespaceDashboardSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector());
    }

    public io.fabric8.openshift.api.model.console.v1.NamespaceDashboardSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new LabelSelectorBuilder().build());
    }

    public io.fabric8.openshift.api.model.console.v1.NamespaceDashboardSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
    }

    public A addToNamespaces(int index,String item) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        this.namespaces.add(index, item);
        return (A)this;
    }

    public A setToNamespaces(int index,String item) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        this.namespaces.set(index, item); return (A)this;
    }

    public A addToNamespaces(String... items) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
        for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A removeFromNamespaces(String... items) {
        for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    public String getLastNamespace() {
        return this.namespaces.get(namespaces.size() - 1);
    }

    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item: namespaces) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item: namespaces) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNamespaces(List<String> namespaces) {
        if (this.namespaces != null) { _visitables.get("namespaces").removeAll(this.namespaces);}
        if (namespaces != null) {this.namespaces = new ArrayList<String>(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
    }

    public A withNamespaces(String... namespaces) {
        if (this.namespaces != null) {this.namespaces.clear();}
        if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
    }

    public Boolean hasNamespaces() {
        return namespaces != null && !namespaces.isEmpty();
    }

    public A addNewNamespace(StringBuilder arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(int[] arg1,int arg2,int arg3) {
        return (A)addToNamespaces(new String(arg1, arg2, arg3));
    }

    public A addNewNamespace(char[] arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(StringBuffer arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(byte[] arg1,int arg2) {
        return (A)addToNamespaces(new String(arg1, arg2));
    }

    public A addNewNamespace(byte[] arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public A addNewNamespace(char[] arg1,int arg2,int arg3) {
        return (A)addToNamespaces(new String(arg1, arg2, arg3));
    }

    public A addNewNamespace(byte[] arg1,int arg2,int arg3) {
        return (A)addToNamespaces(new String(arg1, arg2, arg3));
    }

    public A addNewNamespace(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToNamespaces(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewNamespace(String arg1) {
        return (A)addToNamespaces(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NamespaceDashboardSpecFluentImpl that = (NamespaceDashboardSpecFluentImpl) o;
        if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
        if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(namespaceSelector,  namespaces,  super.hashCode());
    }

    public class NamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<io.fabric8.openshift.api.model.console.v1.NamespaceDashboardSpecFluent.NamespaceSelectorNested<N>> implements io.fabric8.openshift.api.model.console.v1.NamespaceDashboardSpecFluent.NamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            NamespaceSelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            NamespaceSelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) NamespaceDashboardSpecFluentImpl.this.withNamespaceSelector(builder.build());
            }

            public N endNamespaceSelector() {
                return and();
            }
    }


}
