package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleExternalLogLinkSpecBuilder extends ConsoleExternalLogLinkSpecFluentImpl<ConsoleExternalLogLinkSpecBuilder> implements VisitableBuilder<ConsoleExternalLogLinkSpec,ConsoleExternalLogLinkSpecBuilder> {

    ConsoleExternalLogLinkSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleExternalLogLinkSpecBuilder() {
        this(true);
    }

    public ConsoleExternalLogLinkSpecBuilder(Boolean validationEnabled) {
        this(new ConsoleExternalLogLinkSpec(), validationEnabled);
    }

    public ConsoleExternalLogLinkSpecBuilder(ConsoleExternalLogLinkSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleExternalLogLinkSpecBuilder(ConsoleExternalLogLinkSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ConsoleExternalLogLinkSpec(), validationEnabled);
    }

    public ConsoleExternalLogLinkSpecBuilder(ConsoleExternalLogLinkSpecFluent<?> fluent,ConsoleExternalLogLinkSpec instance) {
        this(fluent, instance, true);
    }

    public ConsoleExternalLogLinkSpecBuilder(ConsoleExternalLogLinkSpecFluent<?> fluent,ConsoleExternalLogLinkSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHrefTemplate(instance.getHrefTemplate()); 
        fluent.withNamespaceFilter(instance.getNamespaceFilter()); 
        fluent.withText(instance.getText()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleExternalLogLinkSpecBuilder(ConsoleExternalLogLinkSpec instance) {
        this(instance,true);
    }

    public ConsoleExternalLogLinkSpecBuilder(ConsoleExternalLogLinkSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withHrefTemplate(instance.getHrefTemplate()); 
        this.withNamespaceFilter(instance.getNamespaceFilter()); 
        this.withText(instance.getText()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleExternalLogLinkSpec build() {
        ConsoleExternalLogLinkSpec buildable = new ConsoleExternalLogLinkSpec(fluent.getHrefTemplate(),fluent.getNamespaceFilter(),fluent.getText());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleExternalLogLinkSpecBuilder that = (ConsoleExternalLogLinkSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
