package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ConsoleLinkListFluent<A extends ConsoleLinkListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ConsoleLink item);
    public A setToItems(int index,ConsoleLink item);
    public A addToItems(ConsoleLink... items);
    public A addAllToItems(Collection<ConsoleLink> items);
    public A removeFromItems(ConsoleLink... items);
    public A removeAllFromItems(Collection<ConsoleLink> items);
    public A removeMatchingFromItems(Predicate<ConsoleLinkBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ConsoleLink> getItems();
    public List<ConsoleLink> buildItems();
    public ConsoleLink buildItem(int index);
    public ConsoleLink buildFirstItem();
    public ConsoleLink buildLastItem();
    public ConsoleLink buildMatchingItem(Predicate<ConsoleLinkBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ConsoleLinkBuilder> predicate);
    public A withItems(List<ConsoleLink> items);
    public A withItems(ConsoleLink... items);
    public Boolean hasItems();
    public ConsoleLinkListFluent.ItemsNested<A> addNewItem();
    public ConsoleLinkListFluent.ItemsNested<A> addNewItemLike(ConsoleLink item);
    public ConsoleLinkListFluent.ItemsNested<A> setNewItemLike(int index,ConsoleLink item);
    public ConsoleLinkListFluent.ItemsNested<A> editItem(int index);
    public ConsoleLinkListFluent.ItemsNested<A> editFirstItem();
    public ConsoleLinkListFluent.ItemsNested<A> editLastItem();
    public ConsoleLinkListFluent.ItemsNested<A> editMatchingItem(Predicate<ConsoleLinkBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleLinkFluent<ConsoleLinkListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
