package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ConsoleCLIDownloadSpecFluentImpl<A extends ConsoleCLIDownloadSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConsoleCLIDownloadSpecFluent<A> {

    private String description;
    private String displayName;
    private List<CLIDownloadLinkBuilder> links =  new ArrayList<CLIDownloadLinkBuilder>();

    public ConsoleCLIDownloadSpecFluentImpl() { 
    }


    public ConsoleCLIDownloadSpecFluentImpl(ConsoleCLIDownloadSpec instance) { 
        this.withDescription(instance.getDescription()); 
        this.withDisplayName(instance.getDisplayName()); 
        this.withLinks(instance.getLinks()); 
    }


    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description=description; return (A) this;
    }

    public Boolean hasDescription() {
        return this.description != null;
    }

    public A withNewDescription(String arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuilder arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuffer arg1) {
        return (A)withDescription(new String(arg1));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public A withDisplayName(String displayName) {
        this.displayName=displayName; return (A) this;
    }

    public Boolean hasDisplayName() {
        return this.displayName != null;
    }

    public A withNewDisplayName(String arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(StringBuilder arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(StringBuffer arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A addToLinks(int index,CLIDownloadLink item) {
        if (this.links == null) {this.links = new ArrayList<CLIDownloadLinkBuilder>();}
        CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);_visitables.get("links").add(index >= 0 ? index : _visitables.get("links").size(), builder);this.links.add(index >= 0 ? index : links.size(), builder); return (A)this;
    }

    public A setToLinks(int index,CLIDownloadLink item) {
        if (this.links == null) {this.links = new ArrayList<CLIDownloadLinkBuilder>();}
        CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
        if (index < 0 || index >= _visitables.get("links").size()) { _visitables.get("links").add(builder); } else { _visitables.get("links").set(index, builder);}
        if (index < 0 || index >= links.size()) { links.add(builder); } else { links.set(index, builder);}
         return (A)this;
    }

    public A addToLinks(CLIDownloadLink... items) {
        if (this.links == null) {this.links = new ArrayList<CLIDownloadLinkBuilder>();}
        for (CLIDownloadLink item : items) {CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);_visitables.get("links").add(builder);this.links.add(builder);} return (A)this;
    }

    public A addAllToLinks(Collection<CLIDownloadLink> items) {
        if (this.links == null) {this.links = new ArrayList<CLIDownloadLinkBuilder>();}
        for (CLIDownloadLink item : items) {CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);_visitables.get("links").add(builder);this.links.add(builder);} return (A)this;
    }

    public A removeFromLinks(CLIDownloadLink... items) {
        for (CLIDownloadLink item : items) {CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);_visitables.get("links").remove(builder);if (this.links != null) {this.links.remove(builder);}} return (A)this;
    }

    public A removeAllFromLinks(Collection<CLIDownloadLink> items) {
        for (CLIDownloadLink item : items) {CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);_visitables.get("links").remove(builder);if (this.links != null) {this.links.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromLinks(Predicate<CLIDownloadLinkBuilder> predicate) {
        if (links == null) return (A) this;
        final Iterator<CLIDownloadLinkBuilder> each = links.iterator();
        final List visitables = _visitables.get("links");
        while (each.hasNext()) {
          CLIDownloadLinkBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildLinks instead.
 * @return The buildable object.
 */
@Deprecated public List<CLIDownloadLink> getLinks() {
        return build(links);
    }

    public List<CLIDownloadLink> buildLinks() {
        return build(links);
    }

    public CLIDownloadLink buildLink(int index) {
        return this.links.get(index).build();
    }

    public CLIDownloadLink buildFirstLink() {
        return this.links.get(0).build();
    }

    public CLIDownloadLink buildLastLink() {
        return this.links.get(links.size() - 1).build();
    }

    public CLIDownloadLink buildMatchingLink(Predicate<CLIDownloadLinkBuilder> predicate) {
        for (CLIDownloadLinkBuilder item: links) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingLink(Predicate<CLIDownloadLinkBuilder> predicate) {
        for (CLIDownloadLinkBuilder item: links) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withLinks(List<CLIDownloadLink> links) {
        if (this.links != null) { _visitables.get("links").removeAll(this.links);}
        if (links != null) {this.links = new ArrayList<CLIDownloadLinkBuilder>(); for (CLIDownloadLink item : links){this.addToLinks(item);}} else { this.links = null;} return (A) this;
    }

    public A withLinks(CLIDownloadLink... links) {
        if (this.links != null) {this.links.clear();}
        if (links != null) {for (CLIDownloadLink item :links){ this.addToLinks(item);}} return (A) this;
    }

    public Boolean hasLinks() {
        return links != null && !links.isEmpty();
    }

    public A addNewLink(String href,String text) {
        return (A)addToLinks(new CLIDownloadLink(href, text));
    }

    public ConsoleCLIDownloadSpecFluent.LinksNested<A> addNewLink() {
        return new LinksNestedImpl();
    }

    public ConsoleCLIDownloadSpecFluent.LinksNested<A> addNewLinkLike(CLIDownloadLink item) {
        return new LinksNestedImpl(-1, item);
    }

    public ConsoleCLIDownloadSpecFluent.LinksNested<A> setNewLinkLike(int index,CLIDownloadLink item) {
        return new LinksNestedImpl(index, item);
    }

    public ConsoleCLIDownloadSpecFluent.LinksNested<A> editLink(int index) {
        if (links.size() <= index) throw new RuntimeException("Can't edit links. Index exceeds size.");
        return setNewLinkLike(index, buildLink(index));
    }

    public ConsoleCLIDownloadSpecFluent.LinksNested<A> editFirstLink() {
        if (links.size() == 0) throw new RuntimeException("Can't edit first links. The list is empty.");
        return setNewLinkLike(0, buildLink(0));
    }

    public ConsoleCLIDownloadSpecFluent.LinksNested<A> editLastLink() {
        int index = links.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last links. The list is empty.");
        return setNewLinkLike(index, buildLink(index));
    }

    public ConsoleCLIDownloadSpecFluent.LinksNested<A> editMatchingLink(Predicate<CLIDownloadLinkBuilder> predicate) {
        int index = -1;
        for (int i=0;i<links.size();i++) { 
        if (predicate.test(links.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching links. No match found.");
        return setNewLinkLike(index, buildLink(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConsoleCLIDownloadSpecFluentImpl that = (ConsoleCLIDownloadSpecFluentImpl) o;
        if (description != null ? !description.equals(that.description) :that.description != null) return false;
        if (displayName != null ? !displayName.equals(that.displayName) :that.displayName != null) return false;
        if (links != null ? !links.equals(that.links) :that.links != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(description,  displayName,  links,  super.hashCode());
    }

    public class LinksNestedImpl<N> extends CLIDownloadLinkFluentImpl<ConsoleCLIDownloadSpecFluent.LinksNested<N>> implements ConsoleCLIDownloadSpecFluent.LinksNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CLIDownloadLinkBuilder builder;
        private final int index;

        LinksNestedImpl(int index,CLIDownloadLink item) {
            this.index = index;
            this.builder = new CLIDownloadLinkBuilder(this, item);
        }

        LinksNestedImpl() {
            this.index = -1;
            this.builder = new CLIDownloadLinkBuilder(this);
        }

        public N and() {
             return (N) ConsoleCLIDownloadSpecFluentImpl.this.setToLinks(index,builder.build());
        }

        public N endLink() {
             return and();
        }
    }


}
